/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.range.accessor;

import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.visitor.PathStringBuilderForIATypeVisitor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ColumnRangeFilterValueAccessorFactory
implements IColumnRangeFilterValueAccessorFactory {
    private static final long serialVersionUID = -6341611172763952841L;
    private final ARecordType path;
    private final boolean min;

    public ColumnRangeFilterValueAccessorFactory(ARecordType path, boolean min) {
        this.path = path;
        this.min = min;
    }

    @Override
    public IColumnRangeFilterValueAccessor create(FilterAccessorProvider filterAccessorProvider) throws HyracksDataException {
        return filterAccessorProvider.createRangeFilterValueAccessor(this.path, this.min);
    }

    public String toString() {
        PathStringBuilderForIATypeVisitor pathBuilder = new PathStringBuilderForIATypeVisitor();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.min ? "min" : "max");
        stringBuilder.append('(');
        this.path.accept((IATypeVisitor)pathBuilder, (Object)stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

