/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.merge;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.asterix.column.metadata.AbstractColumnImmutableReadMetadata;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnTupleReader;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReader;

public final class MergeColumnReadMetadata
extends AbstractColumnImmutableReadMetadata {
    private final IColumnValuesReader[] columnReaders;

    private MergeColumnReadMetadata(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, IColumnValuesReader[] columnReaders, IValueReference serializedMetadata) {
        super(datasetType, metaType, numberOfPrimaryKeys, serializedMetadata, columnReaders.length);
        this.columnReaders = columnReaders;
    }

    public static MergeColumnReadMetadata create(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, IColumnValuesReaderFactory readerFactory, IValueReference serializedMetadata) throws IOException {
        byte[] bytes = serializedMetadata.getByteArray();
        int offset = serializedMetadata.getStartOffset();
        int length = serializedMetadata.getLength();
        int pathInfoStart = offset + IntegerPointable.getInteger((byte[])bytes, (int)(offset + 16));
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, pathInfoStart, length));
        int numberOfColumns = input.readInt();
        IColumnValuesReader[] columnReaders = new IColumnValuesReader[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            IColumnValuesReader columnReader;
            columnReaders[columnReader.getColumnIndex()] = columnReader = readerFactory.createValueReader(input);
        }
        return new MergeColumnReadMetadata(datasetType, metaType, numberOfPrimaryKeys, columnReaders, serializedMetadata);
    }

    public IColumnValuesReader[] getColumnReaders() {
        return this.columnReaders;
    }

    public int getColumnIndex(int ordinal) {
        return ordinal;
    }

    public int getNumberOfProjectedColumns() {
        return this.columnReaders.length;
    }

    public int getFilteredColumnIndex(int ordinal) {
        return -1;
    }

    public int getNumberOfFilteredColumns() {
        return 0;
    }

    @Override
    public AbstractColumnTupleReader createTupleReader() {
        return new MergeColumnTupleReader(this);
    }
}

