/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.exceptions.UnsupportedMetadataVersionException;
import org.apache.distributedlog.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogSegmentMetadata
extends ZooKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestLogSegmentMetadata.class);
    static final int TEST_REGION_ID = 14;
    private ZooKeeperClient zkc;

    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().zkServers(zkServers).build();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    @Test(timeout=60000L)
    public void testReadMetadata() throws Exception {
        LogSegmentMetadata metadata1 = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata1", LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION, 1000L, 1L).setRegionId(14).build();
        metadata1.write(this.zkc);
        LogSegmentMetadata read1 = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)LogSegmentMetadata.read((ZooKeeperClient)this.zkc, (String)"/metadata1"));
        Assert.assertEquals((Object)metadata1, (Object)read1);
        Assert.assertEquals((long)14L, (long)read1.getRegionId());
    }

    @Test(timeout=60000L)
    public void testReadMetadataCrossVersion() throws Exception {
        LogSegmentMetadata metadata1 = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata2", 1, 1000L, 1L).setRegionId(14).build();
        metadata1.write(this.zkc);
        LogSegmentMetadata read1 = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)LogSegmentMetadata.read((ZooKeeperClient)this.zkc, (String)"/metadata2", (boolean)true));
        Assert.assertEquals((long)read1.getLogSegmentId(), (long)metadata1.getLogSegmentId());
        Assert.assertEquals((long)read1.getFirstTxId(), (long)metadata1.getFirstTxId());
        Assert.assertEquals((long)read1.getLastTxId(), (long)metadata1.getLastTxId());
        Assert.assertEquals((long)read1.getLogSegmentSequenceNumber(), (long)metadata1.getLogSegmentSequenceNumber());
        Assert.assertEquals((long)0L, (long)read1.getRegionId());
    }

    @Test(timeout=60000L)
    public void testReadMetadataCrossVersionFailure() throws Exception {
        LogSegmentMetadata metadata1 = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata-failure", 1, 1000L, 1L).setRegionId(14).build();
        metadata1.write(this.zkc);
        try {
            LogSegmentMetadata read1 = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)LogSegmentMetadata.read((ZooKeeperClient)this.zkc, (String)"/metadata-failure"));
            Assert.fail((String)"The previous statement should throw an exception");
        }
        catch (UnsupportedMetadataVersionException unsupportedMetadataVersionException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testMutateTruncationStatus() {
        LogSegmentMetadata metadata = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata", LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES, 1L, 0L).setRegionId(0).setLogSegmentSequenceNo(1L).build();
        metadata = metadata.completeLogSegment("/completed-metadata", 1000L, 1000, 1000L, 0L, 0L);
        LogSegmentMetadata partiallyTruncatedSegment = metadata.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.PARTIALLY_TRUNCATED).setMinActiveDLSN(new DLSN(1L, 500L, 0L)).build();
        LogSegmentMetadata fullyTruncatedSegment = partiallyTruncatedSegment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.TRUNCATED).build();
        Assert.assertEquals((Object)new DLSN(1L, 500L, 0L), (Object)fullyTruncatedSegment.getMinActiveDLSN());
    }

    @Test(timeout=60000L)
    public void testParseInvalidMetadata() throws Exception {
        try {
            LogSegmentMetadata.parseData((String)"/metadata1", (byte[])new byte[0], (boolean)false);
            Assert.fail((String)"Should fail to parse invalid metadata");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testReadLogSegmentWithSequenceId() throws Exception {
        LogSegmentMetadata metadata = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata", LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID, 1L, 0L).setRegionId(0).setLogSegmentSequenceNo(1L).setStartSequenceId(999L).build();
        String data = metadata.getFinalisedData();
        LogSegmentMetadata parsedMetadata = LogSegmentMetadata.parseData((String)"/metadatav5", (byte[])data.getBytes(StandardCharsets.UTF_8), (boolean)false);
        Assert.assertEquals((long)999L, (long)parsedMetadata.getStartSequenceId());
        LogSegmentMetadata metadatav4 = new LogSegmentMetadata.LogSegmentMetadataBuilder("/metadata", LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES, 1L, 0L).setRegionId(0).setLogSegmentSequenceNo(1L).setStartSequenceId(999L).build();
        String datav4 = metadatav4.getFinalisedData();
        LogSegmentMetadata parsedMetadatav4 = LogSegmentMetadata.parseData((String)"/metadatav4", (byte[])datav4.getBytes(StandardCharsets.UTF_8), (boolean)false);
        Assert.assertTrue((parsedMetadatav4.getStartSequenceId() < 0L ? 1 : 0) != 0);
    }
}

