---
layout: news_item
date: "2016-03-18 12:00:00 +0000"
author: elserj
version: 1.7.1
categories: [release]
tag: v1-7-1
sha: 11cb0a8
component: avatica
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

Apache Calcite's PMC has just released Avatica 1.7.1, the first
release of [Avatica](http://calcite.apache.org/avatica/) as an
independent project. We're excited because it makes Avatica easier to
use, and allows us to be more agile in our release schedule.

(Avatica was previously released as part of Calcite. Avatica is still
governed by Apache Calcite's PMC, and stored in the same git
repository as Calcite, but releases are no longer synchronized, and
Avatica does not depend on any Calcite modules.)

A significant portion of the work of this release was "Maven work" to
separate the build and release processes, but there were several
important bug fixes, including a security fix for Jetty (see below).

Performance, specifically on the write path, was a big focus in this
release.
[[CALCITE-1091](https://issues.apache.org/jira/browse/CALCITE-1091)]
contained a number of important changes. Some of these changes (e.g.
[[CALCITE-1092](https://issues.apache.org/jira/browse/CALCITE-1092)]
and
[[CALCITE-1093](https://issues.apache.org/jira/browse/CALCITE-1093)])
were related to heap usage in the Avatica server, while
[[CALCITE-1094](https://issues.apache.org/jira/browse/CALCITE-1094)]
and
[[CALCITE-1117](https://issues.apache.org/jira/browse/CALCITE-1117)]
were strictly performance-related.

The latter improved performance the most. Switching to the
[Apache Commons HttpComponents Client](http://hc.apache.org/)
library instead of using the Java platform's built-in
[HttpURLConnection](https://docs.oracle.com/javase/7/docs/api/java/net/HttpURLConnection.html),
we noticed a 15% improvement in pure write workloads.

Three dependent library upgrades:

* We completely removed
  [Commons Logging](https://commons.apache.org/proper/commons-logging/)
  in favor of [SLF4J](http://slf4j.org/) in
  [[CALCITE-669](https://issues.apache.org/jira/browse/CALCITE-669)].
  This logging framework update will allow downstream integrators to
  use the logging implementation of their choice instead of being
  forced to inherit Commons Logging.
* We upgraded Jackson from 2.1.1 to 2.6.3 in
  [[CALCITE-1021](https://issues.apache.org/jira/browse/CALCITE-1021)].
* We upgraded Jetty from 9.2.7.v20150116 to 9.2.15.v20160210 in
  [[CALCITE-1156](https://issues.apache.org/jira/browse/CALCITE-1156)]
  to fix a
  [security issue](https://blog.gdssecurity.com/labs/2015/2/25/jetleak-vulnerability-remote-leakage-of-shared-buffers-in-je.html).

Note that Avatica's Maven coordinates have changed. The `groupId` is
now "org.apache.calcite.avatica" (previously "org.apache.calcite"),
and `artifactId`s are
"avatica",
"avatica-metrics",
"avatica-metrics-dropwizardmetrics3",
"avatica-noop-driver",
"avatica-server"
(previously "calcite-avatica", etc.). Make sure to update these when
upgrading to this version.
