/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.stripe;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

/**
 * Component configuration for Stripe component.
 */
@UriParams
public class StripeConfiguration {

    @UriPath
    @Metadata(required = true, description = "The Stripe operation to perform")
    private StripeOperation operation;

    @UriParam(label = "security", secret = true, description = "The Stripe API key for authentication")
    private String apiKey;

    @UriParam(label = "advanced", description = "Override the default Stripe API base URL (for testing purposes)")
    private String apiBase;

    public StripeOperation getOperation() {
        return operation;
    }

    public void setOperation(StripeOperation operation) {
        this.operation = operation;
    }

    public void setOperation(String operation) {
        this.operation = StripeOperation.fromValue(operation);
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiBase() {
        return apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }
}
