/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsErrors
implements Serializable {
    public final boolean ignore;
    public final int tries;

    public SettingsErrors(Options options) {
        this.ignore = options.ignore.setByUser();
        this.tries = Math.max(1, Integer.parseInt(options.retries.value()) + 1);
    }

    public static SettingsErrors get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-errors");
        if (params == null) {
            return new SettingsErrors(new Options());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsErrors.printHelp();
            System.out.println("Invalid -errors options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsErrors((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-errors", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsErrors.printHelp();
            }
        };
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple retries = new OptionSimple("retries=", "[0-9]+", "9", "Number of tries to perform for each operation before failing", false);
        final OptionSimple ignore = new OptionSimple("ignore", "", null, "Do not fail on errors", false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.retries, this.ignore);
        }
    }
}

