/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDGen {
    public static final int UUID_LEN = 16;

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static ByteBuffer toByteBuffer(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        buffer.flip();
        return buffer;
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }

    public static long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("incompatible with uuid version: " + uuid.version());
        }
        return uuid.timestamp() / 10000L + -12219292800000L;
    }
}

