/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.ResultHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.binlog.BinLog;

public class ResultStore {
    private static final String VERSION = "version";
    private static final String TYPE = "type";
    private static final String ROW = "row";
    private static final String END = "end_resultset";
    private static final String FAILURE = "query_failed";
    private static final String COLUMN_DEFINITIONS = "column_definitions";
    private static final String COLUMN_DEFINITION = "column_definition";
    private static final String COLUMN_COUNT = "column_count";
    private static final String MESSAGE = "message";
    private static final String ROW_COLUMN_COUNT = "row_column_count";
    private static final String COLUMN = "column";
    private static final int CURRENT_VERSION = 0;
    private final List<ChronicleQueue> queues;
    private final List<ExcerptAppender> appenders;
    private final ChronicleQueue queryStoreQueue;
    private final ExcerptAppender queryStoreAppender;
    private final Set<Integer> finishedHosts = new HashSet<Integer>();

    public ResultStore(List<File> resultPaths, File queryFilePath) {
        this.queues = resultPaths.stream().map(path -> SingleChronicleQueueBuilder.single((File)path).build()).collect(Collectors.toList());
        this.appenders = this.queues.stream().map(ChronicleQueue::acquireAppender).collect(Collectors.toList());
        this.queryStoreQueue = queryFilePath != null ? SingleChronicleQueueBuilder.single((File)queryFilePath).build() : null;
        this.queryStoreAppender = this.queryStoreQueue != null ? this.queryStoreQueue.acquireAppender() : null;
    }

    public void storeColumnDefinitions(FQLQuery query, List<ResultHandler.ComparableColumnDefinitions> cds) {
        this.finishedHosts.clear();
        if (this.queryStoreAppender != null) {
            BinLog.ReleaseableWriteMarshallable writeMarshallableQuery = query.toMarshallable();
            this.queryStoreAppender.writeDocument((WriteMarshallable)writeMarshallableQuery);
            writeMarshallableQuery.release();
        }
        for (int i = 0; i < cds.size(); ++i) {
            ResultHandler.ComparableColumnDefinitions cd = cds.get(i);
            this.appenders.get(i).writeDocument((WriteMarshallable)new ColumnDefsWriter(cd));
        }
    }

    public void storeRows(List<ResultHandler.ComparableRow> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            ResultHandler.ComparableRow row = rows.get(i);
            if (row == null && !this.finishedHosts.contains(i)) {
                this.appenders.get(i).writeDocument(wire -> {
                    wire.write((CharSequence)VERSION).int16(0L);
                    wire.write((CharSequence)TYPE).text(END);
                });
                this.finishedHosts.add(i);
                continue;
            }
            if (row == null) continue;
            this.appenders.get(i).writeDocument((WriteMarshallable)new RowWriter(row));
        }
    }

    public void close() {
        this.queues.forEach(Closeable::close);
        if (this.queryStoreQueue != null) {
            this.queryStoreQueue.close();
        }
    }

    static class RowWriter
    implements WriteMarshallable {
        private final ResultHandler.ComparableRow row;

        RowWriter(ResultHandler.ComparableRow row) {
            this.row = row;
        }

        public void writeMarshallable(WireOut wire) {
            wire.write((CharSequence)ResultStore.VERSION).int16(0L);
            wire.write((CharSequence)ResultStore.TYPE).text(ResultStore.ROW);
            wire.write((CharSequence)ResultStore.ROW_COLUMN_COUNT).int32(this.row.getColumnDefinitions().size());
            for (int jj = 0; jj < this.row.getColumnDefinitions().size(); ++jj) {
                ByteBuffer bb = this.row.getBytesUnsafe(jj);
                if (bb != null) {
                    wire.write((CharSequence)ResultStore.COLUMN).bytes(BytesStore.wrap((ByteBuffer)bb));
                    continue;
                }
                wire.write((CharSequence)ResultStore.COLUMN).bytes("NULL".getBytes());
            }
        }
    }

    static class RowReader
    implements ReadMarshallable {
        boolean isFinished;
        List<ByteBuffer> rows = new ArrayList<ByteBuffer>();

        RowReader() {
        }

        public void readMarshallable(WireIn wire) throws IORuntimeException {
            int version = wire.read(ResultStore.VERSION).int32();
            String type = wire.read(ResultStore.TYPE).text();
            if (!type.equals(ResultStore.END)) {
                this.isFinished = false;
                int rowColumnCount = wire.read(ResultStore.ROW_COLUMN_COUNT).int32();
                for (int i = 0; i < rowColumnCount; ++i) {
                    byte[] b = wire.read(ResultStore.COLUMN).bytes();
                    this.rows.add(ByteBuffer.wrap(b));
                }
            } else {
                this.isFinished = true;
            }
        }
    }

    static class ColumnDefsReader
    implements ReadMarshallable {
        boolean wasFailed;
        String failureMessage;
        List<Pair<String, String>> columnDefinitions = new ArrayList<Pair<String, String>>();

        ColumnDefsReader() {
        }

        public void readMarshallable(WireIn wire) throws IORuntimeException {
            short version = wire.read(ResultStore.VERSION).int16();
            String type = wire.read(ResultStore.TYPE).text();
            if (type.equals(ResultStore.FAILURE)) {
                this.wasFailed = true;
                this.failureMessage = wire.read(ResultStore.MESSAGE).text();
            } else if (type.equals(ResultStore.COLUMN_DEFINITION)) {
                int columnCount = wire.read(ResultStore.COLUMN_COUNT).int32();
                for (int i = 0; i < columnCount; ++i) {
                    ValueIn vi = wire.read(ResultStore.COLUMN_DEFINITION);
                    String name = vi.text();
                    String dataType = vi.text();
                    this.columnDefinitions.add((Pair<String, String>)Pair.create((Object)name, (Object)dataType));
                }
            }
        }
    }

    static class ColumnDefsWriter
    implements WriteMarshallable {
        private final ResultHandler.ComparableColumnDefinitions defs;

        ColumnDefsWriter(ResultHandler.ComparableColumnDefinitions defs) {
            this.defs = defs;
        }

        public void writeMarshallable(WireOut wire) {
            wire.write((CharSequence)ResultStore.VERSION).int16(0L);
            if (!this.defs.wasFailed()) {
                wire.write((CharSequence)ResultStore.TYPE).text(ResultStore.COLUMN_DEFINITIONS);
                wire.write((CharSequence)ResultStore.COLUMN_COUNT).int32(this.defs.size());
                for (ResultHandler.ComparableDefinition d : this.defs.asList()) {
                    ValueOut vo = wire.write((CharSequence)ResultStore.COLUMN_DEFINITION);
                    vo.text(d.getName());
                    vo.text(d.getType());
                }
            } else {
                wire.write((CharSequence)ResultStore.TYPE).text(ResultStore.FAILURE);
                wire.write((CharSequence)ResultStore.MESSAGE).text(this.defs.getFailureException().getMessage());
            }
        }
    }
}

