/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.array;

import java.util.Iterator;
import org.psjava.ds.array.Array;
import org.psjava.ds.array.ArrayIterator;
import org.psjava.ds.array.MutableArray;
import org.psjava.util.EqualityTester;
import org.psjava.util.IterableEqualityTester;
import org.psjava.util.IterableToString;
import org.psjava.util.OrderFreeIterableHash;
import org.psjava.util.StrictEqualityTester;

public class DynamicArray<T>
implements MutableArray<T>,
EqualityTester<Array<T>> {
    private T[] a = new Object[1];
    private int asize = 0;

    public static <T> DynamicArray<T> create() {
        return new DynamicArray<T>();
    }

    @Override
    public T get(int index) {
        return this.a[index];
    }

    @Override
    public void set(int index, T value) {
        this.a[index] = value;
    }

    @Override
    public int size() {
        return this.asize;
    }

    public void clear() {
        this.asize = 0;
    }

    public void reserve(int size) {
        if (this.a.length < size) {
            Object[] na = new Object[size];
            for (int i = 0; i < this.a.length; ++i) {
                na[i] = this.a[i];
            }
            this.a = na;
        }
    }

    public void addToLast(T value) {
        if (this.a.length == this.asize) {
            Object[] ta = new Object[this.asize * 2];
            for (int i = 0; i < this.asize; ++i) {
                ta[i] = this.a[i];
            }
            this.a = ta;
        }
        this.a[this.asize++] = value;
    }

    public T removeLast() {
        T r = this.a[this.asize - 1];
        this.a[--this.asize] = null;
        return r;
    }

    public boolean equals(Object obj) {
        return StrictEqualityTester.areEqual(this, obj, this);
    }

    @Override
    public boolean areEqual(Array<T> o1, Array<T> o2) {
        return IterableEqualityTester.areEqual(o1, o2);
    }

    public int hashCode() {
        return OrderFreeIterableHash.hash(this);
    }

    @Override
    public final boolean isEmpty() {
        return this.asize == 0;
    }

    @Override
    public final Iterator<T> iterator() {
        return ArrayIterator.create(this);
    }

    public final String toString() {
        return IterableToString.toString(this);
    }
}

