/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.util.HashMap;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.jetbrains.annotations.Nullable;

public class CloudStorageDataTransferApiFactory {
    public static final CloudStorageDataTransferApiFactory INSTANCE = new CloudStorageDataTransferApiFactory();

    public CloudStorageDataTransferApi createDataTransferApi(StorageClient storageClient, JobInfo jobInfo, ClusterInfo clusterInfo) {
        if (clusterInfo instanceof MultiClusterSupport) {
            MultiClusterSupport multiCluster = (MultiClusterSupport)((Object)clusterInfo);
            return this.createForCoordinated(storageClient, jobInfo, multiCluster);
        }
        return this.createForSingleCluster(storageClient, jobInfo, clusterInfo, null);
    }

    private CloudStorageDataTransferApiImpl createForSingleCluster(StorageClient storageClient, JobInfo jobInfo, ClusterInfo clusterInfo, @Nullable String clusterId) {
        return new CloudStorageDataTransferApiImpl(jobInfo, clusterInfo.getCassandraContext().getSidecarClient(), storageClient, clusterId);
    }

    private CoordinatedCloudStorageDataTransferApi createForCoordinated(StorageClient storageClient, JobInfo jobInfo, MultiClusterSupport<ClusterInfo> clusterInfoGroup) {
        HashMap<String, CloudStorageDataTransferApiImpl> apiByClusterId = new HashMap<String, CloudStorageDataTransferApiImpl>(clusterInfoGroup.size());
        clusterInfoGroup.forEach((clusterId, clusterInfo) -> apiByClusterId.put((String)clusterId, this.createForSingleCluster(storageClient, jobInfo, (ClusterInfo)clusterInfo, (String)clusterId)));
        return new CoordinatedCloudStorageDataTransferApi(apiByClusterId);
    }
}

