/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.cassandra.spark.data.CqlField;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferUtils {
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODER_PROVIDER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);
    public static final int STATIC_MARKER = 65535;
    private static final String EMPTY_STRING = "";
    public static final byte[] EMPTY = new byte[0];
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private ByteBufferUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static void skipBytesFully(DataInput in, int bytes) throws IOException {
        int skipped;
        for (int total = 0; total < bytes; total += skipped) {
            skipped = in.skipBytes(bytes - total);
            if (skipped != 0) continue;
            throw new EOFException("EOF after " + total + " bytes out of " + bytes);
        }
    }

    public static byte[] readRemainingBytes(InputStream in, int size) throws IOException {
        int length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        byte[] bytes = new byte[size];
        while ((length = in.read(bytes)) > 0) {
            out.write(bytes, 0, length);
        }
        return out.toByteArray();
    }

    public static byte[] getArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int boff = buffer.arrayOffset() + buffer.position();
            return Arrays.copyOfRange(buffer.array(), boff, boff + length);
        }
        byte[] bytes = new byte[length];
        buffer.duplicate().get(bytes);
        return bytes;
    }

    public static String readShortLengthCompositeTypeString(ByteBuffer buf) {
        short len = buf.getShort();
        byte[] ar = new byte[len];
        buf.get(ar);
        String str = new String(ar, StandardCharsets.UTF_8);
        buf.get();
        return str;
    }

    public static String string(ByteBuffer buffer, Supplier<CharsetDecoder> decoderSupplier) throws CharacterCodingException {
        return buffer.remaining() <= 0 ? EMPTY_STRING : decoderSupplier.get().decode(buffer.duplicate()).toString();
    }

    public static String string(ByteBuffer buffer) throws CharacterCodingException {
        return ByteBufferUtils.string(buffer, UTF8_DECODER_PROVIDER::get);
    }

    private static String toHexString(byte[] bytes, int length) {
        return ByteBufferUtils.toHexString(bytes, 0, length);
    }

    static String toHexString(byte[] bytes, int offset, int length) {
        char[] hexCharacters = new char[length << 1];
        for (int index = offset; index < offset + length; ++index) {
            int decimalValue = bytes[index] & 0xFF;
            hexCharacters[index - offset << 1] = HEX_ARRAY[decimalValue >> 4];
            hexCharacters[(index - offset << 1) + 1] = HEX_ARRAY[decimalValue & 0xF];
        }
        return new String(hexCharacters);
    }

    public static String toHexString(CqlField.CqlType type, Object value) {
        ByteBuffer buf = value == null ? null : type.serialize(value);
        return ByteBufferUtils.toHexString(buf);
    }

    public static String toHexString(@Nullable ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        if (buffer.isReadOnly()) {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.slice().get(bytes);
            return ByteBufferUtils.toHexString(bytes, bytes.length);
        }
        return ByteBufferUtils.toHexString(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
    }

    public static int readFully(InputStream in, byte[] bytes, int length) throws IOException {
        int total;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (total = 0; total < length && (count = in.read(bytes, total, length - total)) >= 0; total += count) {
        }
        return total;
    }

    public static ByteBuffer readBytesWithShortLength(ByteBuffer buffer) {
        return ByteBufferUtils.readBytes(buffer, ByteBufferUtils.readShortLength(buffer));
    }

    static void writeShortLength(ByteBuffer buffer, int length) {
        buffer.put((byte)(length >> 8 & 0xFF));
        buffer.put((byte)(length & 0xFF));
    }

    static int peekShortLength(ByteBuffer buffer, int position) {
        int length = (buffer.get(position) & 0xFF) << 8;
        return length | buffer.get(position + 1) & 0xFF;
    }

    static int readShortLength(ByteBuffer buffer) {
        int length = (buffer.get() & 0xFF) << 8;
        return length | buffer.get() & 0xFF;
    }

    public static ByteBuffer readBytes(ByteBuffer buffer, int length) {
        ByteBuffer copy = buffer.duplicate();
        ((Buffer)copy).limit(copy.position() + length);
        ((Buffer)buffer).position(buffer.position() + length);
        return copy;
    }

    public static void skipFully(InputStream is, long length) throws IOException {
        long skipped = is.skip(length);
        if (skipped != length) {
            throw new EOFException("EOF after " + skipped + " bytes out of " + length);
        }
    }

    public static ByteBuffer extractComponent(ByteBuffer buffer, int position) {
        buffer = buffer.duplicate();
        ByteBufferUtils.readStatic(buffer);
        int index = 0;
        while (buffer.remaining() > 0) {
            ByteBuffer component = ByteBufferUtils.readBytesWithShortLength(buffer);
            if (index == position) {
                return component;
            }
            buffer.get();
            ++index;
        }
        return null;
    }

    public static ByteBuffer buildPartitionKey(List<CqlField> partitionKeys, Object ... values) {
        if (partitionKeys.size() == 1) {
            CqlField key = partitionKeys.get(0);
            return key.serialize(values[key.position()]);
        }
        ByteBuffer[] buffers = (ByteBuffer[])partitionKeys.stream().map(f -> f.serialize(values[f.position()])).toArray(ByteBuffer[]::new);
        return ByteBufferUtils.build(false, buffers);
    }

    public static ByteBuffer build(boolean isStatic, ByteBuffer ... buffers) {
        int totalLength = isStatic ? 2 : 0;
        for (ByteBuffer buffer : buffers) {
            totalLength += 2 + buffer.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        if (isStatic) {
            out.putShort((short)-1);
        }
        for (ByteBuffer buffer : buffers) {
            ByteBufferUtils.writeShortLength(out, buffer.remaining());
            out.put(buffer.duplicate());
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    public static ByteBuffer[] split(ByteBuffer composite, int numKeys) {
        ByteBuffer[] components = new ByteBuffer[numKeys];
        ByteBuffer buffer = composite.duplicate();
        ByteBufferUtils.readStatic(buffer);
        int index = 0;
        while (buffer.remaining() > 0) {
            components[index++] = ByteBufferUtils.readBytesWithShortLength(buffer);
            buffer.get();
        }
        return index == components.length ? components : Arrays.copyOfRange(components, 0, index);
    }

    public static void readStatic(ByteBuffer buffer) {
        if (buffer.remaining() < 2) {
            return;
        }
        int header = ByteBufferUtils.peekShortLength(buffer, buffer.position());
        if ((header & 0xFFFF) != 65535) {
            return;
        }
        ByteBufferUtils.readShortLength(buffer);
    }
}

