/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl.btc;

import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxException;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.btc.BlockedThreadEvent;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.btc.ThreadInfo;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.Logger;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.LoggerFactory;

public class BlockedThreadChecker {
    public static final String LOGGER_NAME = "o.a.c.sidecar.client.shaded.io.vertx.core.impl.BlockedThreadChecker";
    private static final Logger log = LoggerFactory.getLogger("o.a.c.sidecar.client.shaded.io.vertx.core.impl.BlockedThreadChecker");
    private final Map<Thread, ThreadInfo> threads = new WeakHashMap<Thread, ThreadInfo>();
    private final Timer timer = new Timer("vertx-blocked-thread-checker", true);
    private Handler<BlockedThreadEvent> blockedThreadHandler = BlockedThreadChecker::defaultBlockedThreadHandler;

    public BlockedThreadChecker(long interval, TimeUnit intervalUnit, final long warningExceptionTime, final TimeUnit warningExceptionTimeUnit) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Handler handler;
                ArrayList<BlockedThreadEvent> events = new ArrayList<BlockedThreadEvent>();
                BlockedThreadChecker blockedThreadChecker = BlockedThreadChecker.this;
                synchronized (blockedThreadChecker) {
                    handler = BlockedThreadChecker.this.blockedThreadHandler;
                    long now = System.nanoTime();
                    for (Map.Entry entry : BlockedThreadChecker.this.threads.entrySet()) {
                        ThreadInfo task = (ThreadInfo)entry.getValue();
                        long execStart = task.startTime;
                        long dur = now - execStart;
                        long timeLimit = task.maxExecTime;
                        TimeUnit maxExecTimeUnit = task.maxExecTimeUnit;
                        long maxExecTimeInNanos = TimeUnit.NANOSECONDS.convert(timeLimit, maxExecTimeUnit);
                        long warningExceptionTimeInNanos = TimeUnit.NANOSECONDS.convert(warningExceptionTime, warningExceptionTimeUnit);
                        if (execStart == 0L || dur < maxExecTimeInNanos) continue;
                        events.add(new BlockedThreadEvent((Thread)entry.getKey(), dur, maxExecTimeInNanos, warningExceptionTimeInNanos));
                    }
                }
                events.forEach(handler::handle);
            }
        }, intervalUnit.toMillis(interval), intervalUnit.toMillis(interval));
    }

    public synchronized void setThreadBlockedHandler(Handler<BlockedThreadEvent> handler) {
        this.blockedThreadHandler = handler == null ? BlockedThreadChecker::defaultBlockedThreadHandler : handler;
    }

    public synchronized void registerThread(Thread thread, ThreadInfo checked) {
        this.threads.put(thread, checked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.timer.cancel();
        BlockedThreadChecker blockedThreadChecker = this;
        synchronized (blockedThreadChecker) {
            this.threads.clear();
        }
    }

    private static void defaultBlockedThreadHandler(BlockedThreadEvent bte) {
        Thread thread = bte.thread();
        String message = "Thread Thread[" + thread.getName() + "," + thread.getPriority() + "," + thread.getThreadGroup().getName() + "] has been blocked for " + bte.duration() / 1000000L + " ms, time limit is " + bte.maxExecTime() / 1000000L + " ms";
        if (bte.duration() <= bte.warningExceptionTime()) {
            log.warn(message);
        } else {
            VertxException stackTrace = new VertxException("Thread blocked");
            stackTrace.setStackTrace(thread.getStackTrace());
            log.warn(message, stackTrace);
        }
    }
}

