/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.Pair;

abstract class Ec2MetadataServiceConnector
extends AbstractCloudMetadataServiceConnector {
    static final String EC2_METADATA_TYPE_PROPERTY = "ec2_metadata_type";
    static final String EC2_METADATA_URL_PROPERTY = "ec2_metadata_url";
    static final String DEFAULT_EC2_METADATA_URL = "http://169.254.169.254";

    Ec2MetadataServiceConnector(SnitchProperties properties) {
        super(properties.get(EC2_METADATA_URL_PROPERTY, DEFAULT_EC2_METADATA_URL));
    }

    static Ec2MetadataServiceConnector create(SnitchProperties props) {
        try {
            return EC2MetadataType.valueOf(props.get(EC2_METADATA_TYPE_PROPERTY, EC2MetadataType.v2.name())).create(props);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException(String.format("%s must be one of %s", EC2_METADATA_TYPE_PROPERTY, Arrays.stream(EC2MetadataType.values()).map(Enum::name).collect(Collectors.joining(", "))));
        }
    }

    static class V2Connector
    extends Ec2MetadataServiceConnector {
        static final int MAX_TOKEN_TIME_IN_SECONDS = 21600;
        static final int MIN_TOKEN_TIME_IN_SECONDS = 30;
        static final String AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER_PROPERTY = "ec2_metadata_token_ttl_seconds";
        static final String AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER = "X-aws-ec2-metadata-token-ttl-seconds";
        static final String AWS_EC2_METADATA_TOKEN_HEADER = "X-aws-ec2-metadata-token";
        static final String TOKEN_QUERY = "/latest/api/token";
        @VisibleForTesting
        static int HTTP_REQUEST_RETRIES = 1;
        private Pair<String, Long> token;
        @VisibleForTesting
        final Duration tokenTTL;

        static V2Connector create(SnitchProperties props) {
            Duration tokenTTL;
            String tokenTTLString = props.get(AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER_PROPERTY, Integer.toString(21600));
            try {
                tokenTTL = Duration.ofSeconds(Integer.parseInt(tokenTTLString));
                if (tokenTTL.getSeconds() < 30L || tokenTTL.getSeconds() > 21600L) {
                    throw new ConfigurationException(String.format("property %s was set to %s seconds which is not in allowed range of [%s..%s]", AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER_PROPERTY, tokenTTL.getSeconds(), 30, 21600));
                }
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException(String.format("Unable to parse integer from property %s, value to parse: %s", AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER_PROPERTY, tokenTTLString));
            }
            return new V2Connector(props, tokenTTL);
        }

        V2Connector(SnitchProperties properties, Duration tokenTTL) {
            super(properties);
            this.tokenTTL = tokenTTL;
        }

        @Override
        public String apiCall(String url, String query, String method, Map<String, String> extraHeaders, int expectedResponseCode) throws IOException {
            HashMap<String, String> headers = new HashMap<String, String>(extraHeaders);
            for (int retry = 0; retry <= HTTP_REQUEST_RETRIES; ++retry) {
                String resolvedToken = this.token != null && (Long)this.token.right > System.currentTimeMillis() ? (String)this.token.left : this.getToken();
                try {
                    headers.put(AWS_EC2_METADATA_TOKEN_HEADER, resolvedToken);
                    return super.apiCall(url, query, method, headers, expectedResponseCode);
                }
                catch (AbstractCloudMetadataServiceConnector.HttpException ex) {
                    if (retry == HTTP_REQUEST_RETRIES) {
                        throw ex;
                    }
                    if (ex.responseCode != 401) continue;
                    this.token = null;
                    continue;
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return String.format("%s{%s=%s,%s=%s}", V2Connector.class.getName(), Ec2MetadataServiceConnector.EC2_METADATA_URL_PROPERTY, this.metadataServiceUrl, AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER_PROPERTY, this.tokenTTL.getSeconds());
        }

        @VisibleForTesting
        public synchronized String getToken() {
            try {
                this.token = Pair.create(super.apiCall(this.metadataServiceUrl, TOKEN_QUERY, "PUT", ImmutableMap.of(AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER, String.valueOf(this.tokenTTL.getSeconds())), 200), System.currentTimeMillis() + this.tokenTTL.toMillis() - TimeUnit.SECONDS.toMillis(5L));
                return (String)this.token.left;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class V1Connector
    extends Ec2MetadataServiceConnector {
        static V1Connector create(SnitchProperties props) {
            return new V1Connector(props);
        }

        V1Connector(SnitchProperties props) {
            super(props);
        }

        public String toString() {
            return String.format("%s{%s=%s}", V1Connector.class.getName(), Ec2MetadataServiceConnector.EC2_METADATA_URL_PROPERTY, this.metadataServiceUrl);
        }
    }

    static enum EC2MetadataType {
        v1(props -> V1Connector.create(props)),
        v2(props -> V2Connector.create(props));

        private final Function<SnitchProperties, Ec2MetadataServiceConnector> provider;

        private EC2MetadataType(Function<SnitchProperties, Ec2MetadataServiceConnector> provider) {
            this.provider = provider;
        }

        Ec2MetadataServiceConnector create(SnitchProperties properties) {
            return this.provider.apply(properties);
        }
    }
}

