/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackSampler {
    @NotNull
    private final Thread sampler = new Thread(this::sampling, "Thread sampler");
    private volatile Thread thread = null;
    private volatile StackTraceElement[] stack = null;

    public StackSampler() {
        this.sampler.setDaemon(true);
        this.sampler.start();
    }

    void sampling() {
        while (!Thread.currentThread().isInterrupted()) {
            Thread t2 = this.thread;
            if (t2 != null) {
                StackTraceElement[] stack0 = t2.getStackTrace();
                if (this.thread == t2) {
                    this.stack = stack0;
                }
            }
            LockSupport.parkNanos(10000L);
        }
    }

    public void stop() {
        this.sampler.interrupt();
    }

    public void thread(Thread thread) {
        this.thread = thread;
    }

    @Nullable
    public StackTraceElement[] getAndReset() {
        StackTraceElement[] lStack = this.stack;
        this.thread = null;
        this.stack = null;
        return lStack;
    }
}

