/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;

public class Long2LongCounterMap {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long initialValue;
    private int resizeThreshold;
    private int size = 0;
    private long[] entries;

    public Long2LongCounterMap(long initialValue) {
        this(8, 0.65f, initialValue);
    }

    public Long2LongCounterMap(int initialCapacity, float loadFactor, long initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public long initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public long get(long key) {
        long value;
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Long2LongCounterMap.next(index, mask);
        }
        return value;
    }

    public long put(long key, long value) {
        long oldValue;
        long initialValue = this.initialValue;
        if (initialValue == value) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Long2LongCounterMap.next(index, mask);
        }
        if (initialValue == oldValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public long incrementAndGet(long key) {
        return this.addAndGet(key, 1L);
    }

    public long decrementAndGet(long key) {
        return this.addAndGet(key, -1L);
    }

    public long addAndGet(long key, long amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public long getAndIncrement(long key) {
        return this.getAndAdd(key, 1L);
    }

    public long getAndDecrement(long key) {
        return this.getAndAdd(key, -1L);
    }

    public long getAndAdd(long key, long amount) {
        long oldValue;
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Long2LongCounterMap.next(index, mask);
        }
        if (amount != 0L) {
            long newValue;
            entries[index + 1] = newValue = oldValue + amount;
            if (initialValue == oldValue) {
                ++this.size;
                entries[index] = key;
                this.increaseCapacity();
            } else if (initialValue == newValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    public void forEach(LongLongConsumer consumer) {
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int i = 1; remaining > 0 && i < length; i += 2) {
            long value = entries[i];
            if (initialValue == value) continue;
            consumer.accept(entries[i - 1], value);
            --remaining;
        }
    }

    public boolean containsKey(long key) {
        return this.initialValue != this.get(key);
    }

    public boolean containsValue(long value) {
        boolean found = false;
        if (this.initialValue != value) {
            long[] entries = this.entries;
            int length = entries.length;
            for (int i = 1; i < length; i += 2) {
                if (value != entries[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        long value = this.get(key);
        if (this.initialValue == value && this.initialValue != (value = mappingFunction.applyAsLong(key))) {
            this.put(key, value);
        }
        return value;
    }

    public long remove(long key) {
        long oldValue;
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = initialValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Long2LongCounterMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public long minValue() {
        long initialValue = this.initialValue;
        long min2 = 0 == this.size ? initialValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (initialValue == value) continue;
            min2 = Math.min(min2, value);
        }
        return min2;
    }

    public long maxValue() {
        long initialValue = this.initialValue;
        long max = 0 == this.size ? initialValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (initialValue == value) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (initialValue == value) continue;
            sb.append(entries[i - 1]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void compactChain(int deleteKeyIndex) {
        long value;
        long initialValue = this.initialValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = deleteKeyIndex;
        while (initialValue != (value = entries[(index = Long2LongCounterMap.next(index, mask)) + 1])) {
            long key = entries[index];
            int hash = Hashing.evenHash(key, mask);
            if ((index >= hash || hash > deleteKeyIndex && deleteKeyIndex > index) && (hash > deleteKeyIndex || deleteKeyIndex > index)) continue;
            entries[deleteKeyIndex] = key;
            entries[deleteKeyIndex + 1] = value;
            entries[index + 1] = initialValue;
            deleteKeyIndex = index;
        }
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long initialValue = this.initialValue;
        long[] oldEntries = this.entries;
        int length = oldEntries.length;
        this.capacity(newCapacity);
        long[] newEntries = this.entries;
        int mask = newEntries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            long value = oldEntries[keyIndex + 1];
            if (initialValue == value) continue;
            long key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (initialValue != newEntries[index + 1]) {
                index = Long2LongCounterMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }
}

