/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.TimeFcts;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.StringUtils;

public final class CastFcts {
    private static final String FUNCTION_NAME_PREFIX = "cast_as_";
    private static final String LEGACY_FUNCTION_NAME_PREFIX = "castAs";

    public static void addFunctionsTo(NativeFunctions functions) {
        AbstractType[] numericTypes;
        for (AbstractType inputType : numericTypes = new AbstractType[]{ByteType.instance, ShortType.instance, Int32Type.instance, LongType.instance, FloatType.instance, DoubleType.instance, DecimalType.instance, CounterColumnType.instance, IntegerType.instance}) {
            CastFcts.addFunctionIfNeeded(functions, inputType, ByteType.instance, Number::byteValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, ShortType.instance, Number::shortValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, Int32Type.instance, Number::intValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, LongType.instance, Number::longValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, FloatType.instance, Number::floatValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, DoubleType.instance, Number::doubleValue);
            CastFcts.addFunctionIfNeeded(functions, inputType, DecimalType.instance, CastFcts.getDecimalConversionFunction(inputType));
            CastFcts.addFunctionIfNeeded(functions, inputType, IntegerType.instance, p -> BigInteger.valueOf(p.longValue()));
            functions.add(CastAsTextFunction.create(inputType, AsciiType.instance));
            functions.add(CastAsTextFunction.create(inputType, UTF8Type.instance));
        }
        functions.add(JavaFunctionWrapper.create(AsciiType.instance, UTF8Type.instance, p -> p));
        functions.add(CastAsTextFunction.create(InetAddressType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(InetAddressType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(BooleanType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(BooleanType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(TimeUUIDType.instance, SimpleDateType.instance, TimeFcts.toDate(TimeUUIDType.instance)));
        functions.add(CassandraFunctionWrapper.create(TimeUUIDType.instance, TimestampType.instance, TimeFcts.toTimestamp(TimeUUIDType.instance)));
        functions.add(CastAsTextFunction.create(TimeUUIDType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimeUUIDType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(TimestampType.instance, SimpleDateType.instance, TimeFcts.toDate(TimestampType.instance)));
        functions.add(CastAsTextFunction.create(TimestampType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimestampType.instance, UTF8Type.instance));
        functions.add(CassandraFunctionWrapper.create(SimpleDateType.instance, TimestampType.instance, TimeFcts.toTimestamp(SimpleDateType.instance)));
        functions.add(CastAsTextFunction.create(SimpleDateType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(SimpleDateType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(TimeType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(TimeType.instance, UTF8Type.instance));
        functions.add(CastAsTextFunction.create(UUIDType.instance, AsciiType.instance));
        functions.add(CastAsTextFunction.create(UUIDType.instance, UTF8Type.instance));
    }

    private static <I extends Number> Function<I, BigDecimal> getDecimalConversionFunction(AbstractType<? extends Number> inputType) {
        if (inputType == FloatType.instance) {
            return p -> new BigDecimal(Float.toString(p.floatValue()));
        }
        if (inputType == DoubleType.instance) {
            return p -> BigDecimal.valueOf(p.doubleValue());
        }
        if (inputType == IntegerType.instance) {
            return p -> new BigDecimal((BigInteger)p);
        }
        return p -> BigDecimal.valueOf(p.longValue());
    }

    public static String getFunctionName(CQL3Type outputType) {
        return FUNCTION_NAME_PREFIX + CastFcts.toLowerCaseString(outputType);
    }

    private static String getLegacyFunctionName(CQL3Type outputType) {
        return LEGACY_FUNCTION_NAME_PREFIX + StringUtils.capitalize((String)CastFcts.toLowerCaseString(outputType));
    }

    private static String getFunctionName(AbstractType<?> outputType, boolean legacy) {
        CQL3Type type = outputType.asCQL3Type();
        return legacy ? CastFcts.getLegacyFunctionName(type) : CastFcts.getFunctionName(type);
    }

    private static <I, O> void addFunctionIfNeeded(NativeFunctions functions, AbstractType<I> inputType, AbstractType<O> outputType, Function<I, O> converter) {
        if (!inputType.equals(outputType)) {
            functions.add(CastFcts.wrapJavaFunction(inputType, outputType, converter));
        }
    }

    private static <O, I> CastFunction<?, O> wrapJavaFunction(AbstractType<I> inputType, AbstractType<O> outputType, Function<I, O> converter) {
        return inputType.equals(CounterColumnType.instance) ? JavaCounterFunctionWrapper.create(outputType, converter) : JavaFunctionWrapper.create(inputType, outputType, converter);
    }

    private static String toLowerCaseString(CQL3Type type) {
        return type.toString().toLowerCase();
    }

    private CastFcts() {
    }

    private static final class CastAsTextFunction<I>
    extends CastFunction<I, String> {
        public static <I> CastAsTextFunction<I> create(AbstractType<I> inputType, AbstractType<String> outputType) {
            return new CastAsTextFunction<I>(inputType, outputType, false);
        }

        private CastAsTextFunction(AbstractType<I> inputType, AbstractType<String> outputType, boolean useLegacyName) {
            super(inputType, outputType, useLegacyName);
        }

        @Override
        public CastAsTextFunction<I> withLegacyName() {
            return new CastAsTextFunction(this.inputType(), this.outputType(), true);
        }

        @Override
        public Arguments newArguments(ProtocolVersion version) {
            return new FunctionArguments(version, (protocolVersion, buffer) -> {
                AbstractType argType = (AbstractType)this.argTypes.get(0);
                if (buffer == null || !buffer.hasRemaining() && argType.isEmptyValueMeaningless()) {
                    return null;
                }
                return argType.getSerializer().toCQLLiteralNoQuote(buffer);
            });
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            if (arguments.containsNulls()) {
                return null;
            }
            return this.outputType().decompose((String)arguments.get(0));
        }
    }

    private static final class CassandraFunctionWrapper<I, O>
    extends CastFunction<I, O> {
        private final NativeScalarFunction delegate;

        public static <I, O> CassandraFunctionWrapper<I, O> create(AbstractType<I> inputType, AbstractType<O> outputType, NativeScalarFunction delegate) {
            return new CassandraFunctionWrapper<I, O>(inputType, outputType, delegate, false);
        }

        private CassandraFunctionWrapper(AbstractType<I> inputType, AbstractType<O> outputType, NativeScalarFunction delegate, boolean useLegacyName) {
            super(inputType, outputType, useLegacyName);
            assert (delegate.argTypes().size() == 1 && inputType.equals(delegate.argTypes().get(0)));
            assert (outputType.equals(delegate.returnType()));
            this.delegate = delegate;
        }

        @Override
        public CassandraFunctionWrapper<I, O> withLegacyName() {
            return new CassandraFunctionWrapper(this.inputType(), this.outputType(), this.delegate, true);
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            return this.delegate.execute(arguments);
        }
    }

    private static class JavaCounterFunctionWrapper<O>
    extends JavaFunctionWrapper<Long, O> {
        public static <O> JavaFunctionWrapper<Long, O> create(AbstractType<O> outputType, Function<Long, O> converter) {
            return new JavaCounterFunctionWrapper<O>(outputType, converter, false);
        }

        protected JavaCounterFunctionWrapper(AbstractType<O> outputType, Function<Long, O> converter, boolean useLegacyName) {
            super(CounterColumnType.instance, outputType, converter, useLegacyName);
        }

        @Override
        public JavaCounterFunctionWrapper<O> withLegacyName() {
            return new JavaCounterFunctionWrapper(this.outputType(), this.converter, true);
        }

        @Override
        protected Long compose(ByteBuffer bb) {
            return (Long)LongType.instance.compose(bb);
        }
    }

    private static class JavaFunctionWrapper<I, O>
    extends CastFunction<I, O> {
        protected final Function<I, O> converter;

        public static <I, O> JavaFunctionWrapper<I, O> create(AbstractType<I> inputType, AbstractType<O> outputType, Function<I, O> converter) {
            return new JavaFunctionWrapper<I, O>(inputType, outputType, converter, false);
        }

        protected JavaFunctionWrapper(AbstractType<I> inputType, AbstractType<O> outputType, Function<I, O> converter, boolean useLegacyName) {
            super(inputType, outputType, useLegacyName);
            this.converter = converter;
        }

        @Override
        public JavaFunctionWrapper<I, O> withLegacyName() {
            return new JavaFunctionWrapper(this.inputType(), this.outputType(), this.converter, true);
        }

        @Override
        public final ByteBuffer execute(Arguments arguments) {
            if (arguments.containsNulls()) {
                return null;
            }
            return this.outputType().decompose(this.converter.apply(arguments.get(0)));
        }

        protected I compose(ByteBuffer bb) {
            return this.inputType().compose(bb);
        }
    }

    private static abstract class CastFunction<I, O>
    extends NativeScalarFunction {
        public CastFunction(AbstractType<I> inputType, AbstractType<O> outputType, boolean useLegacyName) {
            super(CastFcts.getFunctionName(outputType, useLegacyName), outputType, inputType);
        }

        @Override
        public String columnName(List<String> columnNames) {
            return String.format("cast(%s as %s)", columnNames.get(0), CastFcts.toLowerCaseString(this.outputType().asCQL3Type()));
        }

        protected AbstractType<O> outputType() {
            return this.returnType;
        }

        protected AbstractType<I> inputType() {
            return (AbstractType)this.argTypes.get(0);
        }
    }
}

