/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.exceptions.InvalidTypeException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.JavaDriverUtils;

public final class UDFDataType {
    private static final Pattern JAVA_LANG_PREFIX = Pattern.compile("\\bjava\\.lang\\.");
    private final AbstractType<?> abstractType;
    private final TypeCodec<?> typeCodec;
    private final TypeToken<?> javaType;

    private UDFDataType(AbstractType<?> abstractType, boolean usePrimitive) {
        this.abstractType = abstractType;
        this.typeCodec = JavaDriverUtils.codecFor(abstractType);
        TypeToken<?> token = this.typeCodec.getJavaType();
        this.javaType = usePrimitive ? token.unwrap() : token;
    }

    public AbstractType<?> toAbstractType() {
        return this.abstractType;
    }

    public Class<?> toJavaClass() {
        return this.typeCodec.getJavaType().getRawType();
    }

    public String getJavaTypeName() {
        String n = this.javaType.toString();
        return JAVA_LANG_PREFIX.matcher(n).replaceAll("");
    }

    public boolean isPrimitive() {
        return this.javaType.isPrimitive();
    }

    public static UDFDataType wrap(AbstractType<?> abstractType, boolean usePrimitive) {
        return new UDFDataType(abstractType, usePrimitive);
    }

    public static List<UDFDataType> wrap(List<AbstractType<?>> argTypes, boolean usePrimitive) {
        ArrayList<UDFDataType> types = new ArrayList<UDFDataType>(argTypes.size());
        for (AbstractType<?> argType : argTypes) {
            types.add(UDFDataType.wrap(argType, usePrimitive));
        }
        return types;
    }

    public DataType toDataType() {
        return this.typeCodec.getCqlType();
    }

    public int hashCode() {
        return Objects.hashCode(this.abstractType, this.javaType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UDFDataType)) {
            return false;
        }
        UDFDataType that = (UDFDataType)obj;
        return this.abstractType.equals(that.abstractType) && this.javaType.equals(that.javaType);
    }

    public Object compose(ProtocolVersion protocolVersion, ByteBuffer buffer) {
        if (buffer == null || buffer.remaining() == 0 && this.abstractType.isEmptyValueMeaningless()) {
            return null;
        }
        return this.typeCodec.deserialize(buffer, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, Object value) {
        if (value == null) {
            return null;
        }
        if (!this.toJavaClass().isAssignableFrom(value.getClass())) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return this.typeCodec.serialize(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, byte value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveByteCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveByteCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, short value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveShortCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveShortCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, int value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveIntCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveIntCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, long value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveLongCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveLongCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, float value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveFloatCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveFloatCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ByteBuffer decompose(ProtocolVersion protocolVersion, double value) {
        if (!(this.typeCodec instanceof TypeCodec.PrimitiveDoubleCodec)) {
            throw new InvalidTypeException("Invalid value for CQL type " + this.toDataType().getName());
        }
        return ((TypeCodec.PrimitiveDoubleCodec)this.typeCodec).serializeNoBoxing(value, protocolVersion);
    }

    public ArgumentDeserializer getArgumentDeserializer() {
        if (this.isPrimitive()) {
            return this.abstractType.getArgumentDeserializer();
        }
        return this::compose;
    }
}

