/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.ColumnFilterFactory;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.SelectionColumns;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.JsonUtils;

public abstract class Selection {
    private static final Predicate<ColumnMetadata> STATIC_COLUMN_FILTER = column -> column.isStatic();
    private final TableMetadata table;
    private final List<ColumnMetadata> columns;
    private final SelectionColumnMapping columnMapping;
    protected final ResultSet.ResultMetadata metadata;
    protected final ColumnFilterFactory columnFilterFactory;
    protected final boolean isJson;
    protected final List<ColumnMetadata> orderingColumns;

    protected Selection(TableMetadata table, List<ColumnMetadata> selectedColumns, Set<ColumnMetadata> orderingColumns, SelectionColumnMapping columnMapping, ColumnFilterFactory columnFilterFactory, boolean isJson) {
        this.table = table;
        this.columns = selectedColumns;
        this.columnMapping = columnMapping;
        this.metadata = new ResultSet.ResultMetadata(columnMapping.getColumnSpecifications());
        this.columnFilterFactory = columnFilterFactory;
        this.isJson = isJson;
        this.columns.addAll(orderingColumns);
        this.metadata.addNonSerializedColumns(orderingColumns);
        this.orderingColumns = orderingColumns.isEmpty() ? Collections.emptyList() : new ArrayList<ColumnMetadata>(orderingColumns);
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean containsStaticColumns() {
        if (this.table.isStaticCompactTable() || !this.table.hasStaticColumns()) {
            return false;
        }
        if (this.isWildcard()) {
            return true;
        }
        return !Iterables.isEmpty(Iterables.filter(this.columns, STATIC_COLUMN_FILTER));
    }

    public Integer getOrderingIndex(ColumnMetadata c) {
        if (this.isJson) {
            return this.orderingColumns.indexOf(c) + 1;
        }
        if (c.isMasked()) {
            return this.columns.lastIndexOf(c);
        }
        return this.getResultSetIndex(c);
    }

    public ResultSet.ResultMetadata getResultMetadata() {
        if (!this.isJson) {
            return this.metadata;
        }
        ColumnSpecification firstColumn = this.metadata.names.get(0);
        ColumnSpecification jsonSpec = new ColumnSpecification(firstColumn.ksName, firstColumn.cfName, Json.JSON_COLUMN_ID, UTF8Type.instance);
        ResultSet.ResultMetadata resultMetadata = new ResultSet.ResultMetadata(Lists.newArrayList(jsonSpec));
        resultMetadata.addNonSerializedColumns(this.orderingColumns);
        return resultMetadata;
    }

    public static Selection wildcard(TableMetadata table, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
        ArrayList<ColumnMetadata> all = new ArrayList<ColumnMetadata>(table.columns().size());
        Iterators.addAll(all, table.allColumnsInSelectOrder());
        return new SimpleSelection(table, all, Collections.emptySet(), true, isJson, returnStaticContentOnPartitionWithNoRows);
    }

    public static Selection wildcardWithGroupByOrMaskedColumns(TableMetadata table, VariableSpecifications boundNames, Set<ColumnMetadata> orderingColumns, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
        return Selection.fromSelectors(table, Lists.newArrayList(table.allColumnsInSelectOrder()), boundNames, orderingColumns, Collections.emptySet(), true, isJson, returnStaticContentOnPartitionWithNoRows);
    }

    public static Selection forColumns(TableMetadata table, List<ColumnMetadata> columns, boolean returnStaticContentOnPartitionWithNoRows) {
        return new SimpleSelection(table, columns, Collections.emptySet(), false, false, returnStaticContentOnPartitionWithNoRows);
    }

    public void addFunctionsTo(List<Function> functions) {
    }

    private static boolean processesSelection(List<Selectable> selectables) {
        for (Selectable selectable : selectables) {
            if (!selectable.processesSelection()) continue;
            return true;
        }
        return false;
    }

    public static Selection fromSelectors(TableMetadata table, List<Selectable> selectables, VariableSpecifications boundNames, Set<ColumnMetadata> orderingColumns, Set<ColumnMetadata> nonPKRestrictedColumns, boolean hasGroupBy, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
        ArrayList<ColumnMetadata> selectedColumns = new ArrayList<ColumnMetadata>();
        SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(selectables, null, table, selectedColumns, boundNames);
        SelectionColumnMapping mapping = Selection.collectColumnMappings(table, factories);
        Set<ColumnMetadata> filteredOrderingColumns = Selection.filterOrderingColumns(orderingColumns, selectedColumns, factories, isJson);
        return Selection.processesSelection(selectables) || selectables.size() != selectedColumns.size() || hasGroupBy ? new SelectionWithProcessing(table, selectedColumns, filteredOrderingColumns, nonPKRestrictedColumns, mapping, factories, isJson, returnStaticContentOnPartitionWithNoRows) : new SimpleSelection(table, selectedColumns, filteredOrderingColumns, nonPKRestrictedColumns, mapping, isJson, returnStaticContentOnPartitionWithNoRows);
    }

    private static Set<ColumnMetadata> filterOrderingColumns(Set<ColumnMetadata> orderingColumns, List<ColumnMetadata> selectedColumns, SelectorFactories factories, boolean isJson) {
        if (isJson) {
            return orderingColumns;
        }
        LinkedHashSet<ColumnMetadata> filteredOrderingColumns = new LinkedHashSet<ColumnMetadata>(orderingColumns.size());
        for (ColumnMetadata orderingColumn : orderingColumns) {
            int index = selectedColumns.indexOf(orderingColumn);
            if (index >= 0 && factories.indexOfSimpleSelectorFactory(index) >= 0 && !orderingColumn.isMasked()) continue;
            filteredOrderingColumns.add(orderingColumn);
        }
        return filteredOrderingColumns;
    }

    public int getResultSetIndex(ColumnMetadata c) {
        return this.getColumnIndex(c);
    }

    protected final int getColumnIndex(ColumnMetadata c) {
        return this.columns.indexOf(c);
    }

    private static SelectionColumnMapping collectColumnMappings(TableMetadata table, SelectorFactories factories) {
        SelectionColumnMapping selectionColumns = SelectionColumnMapping.newMapping();
        for (Selector.Factory factory : factories) {
            ColumnSpecification colSpec = factory.getColumnSpecification(table);
            factory.addColumnMapping(selectionColumns, colSpec);
        }
        return selectionColumns;
    }

    public abstract Selectors newSelectors(QueryOptions var1);

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public SelectionColumns getColumnMapping() {
        return this.columnMapping;
    }

    public abstract boolean isAggregate();

    public String toString() {
        return MoreObjects.toStringHelper(this).add("columns", this.columns).add("columnMapping", this.columnMapping).add("metadata", this.metadata).toString();
    }

    private static List<ByteBuffer> rowToJson(List<ByteBuffer> row, ProtocolVersion protocolVersion, ResultSet.ResultMetadata metadata, List<ColumnMetadata> orderingColumns) {
        ByteBuffer[] jsonRow = new ByteBuffer[orderingColumns.size() + 1];
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < metadata.names.size(); ++i) {
            Object columnName;
            ColumnSpecification spec = metadata.names.get(i);
            ByteBuffer buffer = row.get(i);
            int index = orderingColumns.indexOf(spec);
            if (index >= 0) {
                jsonRow[index + 1] = buffer;
            }
            if (i >= metadata.getColumnCount()) continue;
            if (i > 0) {
                sb.append(", ");
            }
            if (!((String)(columnName = spec.name.toString())).equals(((String)columnName).toLowerCase(Locale.US))) {
                columnName = "\"" + (String)columnName + "\"";
            }
            sb.append('\"');
            sb.append(JsonUtils.quoteAsJsonString((String)columnName));
            sb.append("\": ");
            if (buffer == null) {
                sb.append("null");
                continue;
            }
            sb.append(spec.type.toJSONString(buffer, protocolVersion));
        }
        sb.append("}");
        jsonRow[0] = UTF8Type.instance.getSerializer().serialize(sb.toString());
        return Arrays.asList(jsonRow);
    }

    private static class SelectionWithProcessing
    extends Selection {
        private final SelectorFactories factories;
        private final boolean collectWritetimes;
        private final boolean collectMaxWritetimes;
        private final boolean collectTTLs;

        public SelectionWithProcessing(TableMetadata table, List<ColumnMetadata> columns, Set<ColumnMetadata> orderingColumns, Set<ColumnMetadata> nonPKRestrictedColumns, SelectionColumnMapping metadata, SelectorFactories factories, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
            super(table, columns, orderingColumns, metadata, ColumnFilterFactory.fromSelectorFactories(table, factories, orderingColumns, nonPKRestrictedColumns, returnStaticContentOnPartitionWithNoRows), isJson);
            this.factories = factories;
            this.collectWritetimes = factories.containsWritetimeSelectorFactory();
            this.collectMaxWritetimes = factories.containsMaxWritetimeSelectorFactory();
            this.collectTTLs = factories.containsTTLSelectorFactory();
            for (ColumnMetadata orderingColumn : orderingColumns) {
                factories.addSelectorForOrdering(orderingColumn, this.getColumnIndex(orderingColumn));
            }
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.factories.addFunctionsTo(functions);
        }

        @Override
        public int getResultSetIndex(ColumnMetadata c) {
            return this.factories.indexOfSimpleSelectorFactory(super.getResultSetIndex(c));
        }

        @Override
        public boolean isAggregate() {
            return this.factories.doesAggregation();
        }

        @Override
        public Selectors newSelectors(final QueryOptions options) throws InvalidRequestException {
            return new Selectors(){
                private final List<Selector> selectors;
                {
                    this.selectors = factories.newInstances(options);
                }

                @Override
                public void reset() {
                    for (Selector selector : this.selectors) {
                        selector.reset();
                    }
                }

                @Override
                public boolean isAggregate() {
                    return factories.doesAggregation();
                }

                @Override
                public boolean hasProcessing() {
                    return true;
                }

                @Override
                public List<ByteBuffer> getOutputRow() {
                    ArrayList<ByteBuffer> outputRow = new ArrayList<ByteBuffer>(this.selectors.size());
                    for (Selector selector : this.selectors) {
                        outputRow.add(selector.getOutput(options.getProtocolVersion()));
                    }
                    return isJson ? Selection.rowToJson(outputRow, options.getProtocolVersion(), metadata, orderingColumns) : outputRow;
                }

                @Override
                public void addInputRow(Selector.InputRow input) {
                    for (Selector selector : this.selectors) {
                        selector.addInput(input);
                    }
                }

                @Override
                public int numberOfFetchedColumns() {
                    return this.getColumns().size();
                }

                @Override
                public boolean collectTTLs() {
                    return collectTTLs;
                }

                @Override
                public boolean collectWritetimes() {
                    return collectWritetimes || collectMaxWritetimes;
                }

                @Override
                public ColumnFilter getColumnFilter() {
                    return columnFilterFactory.newInstance(this.selectors);
                }
            };
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(TableMetadata table, List<ColumnMetadata> selectedColumns, Set<ColumnMetadata> orderingColumns, boolean isWildcard, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
            this(table, selectedColumns, orderingColumns, SelectionColumnMapping.simpleMapping(selectedColumns), isWildcard ? ColumnFilterFactory.wildcard(table) : ColumnFilterFactory.fromColumns(table, selectedColumns, orderingColumns, Collections.emptySet(), returnStaticContentOnPartitionWithNoRows), isWildcard, isJson);
        }

        public SimpleSelection(TableMetadata table, List<ColumnMetadata> selectedColumns, Set<ColumnMetadata> orderingColumns, Set<ColumnMetadata> nonPKRestrictedColumns, SelectionColumnMapping mapping, boolean isJson, boolean returnStaticContentOnPartitionWithNoRows) {
            this(table, selectedColumns, orderingColumns, mapping, ColumnFilterFactory.fromColumns(table, selectedColumns, orderingColumns, nonPKRestrictedColumns, returnStaticContentOnPartitionWithNoRows), false, isJson);
        }

        private SimpleSelection(TableMetadata table, List<ColumnMetadata> selectedColumns, Set<ColumnMetadata> orderingColumns, SelectionColumnMapping mapping, ColumnFilterFactory columnFilterFactory, boolean isWildcard, boolean isJson) {
            super(table, selectedColumns, orderingColumns, mapping, columnFilterFactory, isJson);
            this.isWildcard = isWildcard;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }

        @Override
        public boolean isAggregate() {
            return false;
        }

        @Override
        public Selectors newSelectors(final QueryOptions options) {
            return new Selectors(){
                private List<ByteBuffer> current;

                @Override
                public void reset() {
                    this.current = null;
                }

                @Override
                public List<ByteBuffer> getOutputRow() {
                    if (isJson) {
                        return Selection.rowToJson(this.current, options.getProtocolVersion(), metadata, orderingColumns);
                    }
                    return this.current;
                }

                @Override
                public void addInputRow(Selector.InputRow input) {
                    this.current = input.getValues();
                }

                @Override
                public boolean isAggregate() {
                    return false;
                }

                @Override
                public boolean hasProcessing() {
                    return false;
                }

                @Override
                public int numberOfFetchedColumns() {
                    return this.getColumns().size();
                }

                @Override
                public boolean collectTTLs() {
                    return false;
                }

                @Override
                public boolean collectWritetimes() {
                    return false;
                }

                @Override
                public ColumnFilter getColumnFilter() {
                    return columnFilterFactory.newInstance(null);
                }
            };
        }
    }

    public static interface Selectors {
        public ColumnFilter getColumnFilter();

        public boolean hasProcessing();

        public boolean isAggregate();

        public int numberOfFetchedColumns();

        public boolean collectTTLs();

        public boolean collectWritetimes();

        public void addInputRow(Selector.InputRow var1);

        public List<ByteBuffer> getOutputRow();

        public void reset();
    }
}

