/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.ShardManagerDiskAware;
import org.apache.cassandra.db.compaction.ShardManagerNoDisks;
import org.apache.cassandra.db.compaction.ShardManagerTrivial;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public interface ShardManager {
    public static final double MINIMUM_TOKEN_COVERAGE = Math.scalb(1.0, -48);

    public static ShardManager create(ColumnFamilyStore cfs) {
        ImmutableList<PartitionPosition> diskPositions = cfs.getDiskBoundaries().positions;
        ColumnFamilyStore.VersionedLocalRanges localRanges = cfs.localRangesWeighted();
        IPartitioner partitioner = cfs.getPartitioner();
        if (diskPositions != null && diskPositions.size() > 1) {
            return new ShardManagerDiskAware(localRanges, diskPositions.stream().map(RingPosition::getToken).collect(Collectors.toList()));
        }
        if (partitioner.splitter().isPresent()) {
            return new ShardManagerNoDisks(localRanges);
        }
        return new ShardManagerTrivial(partitioner);
    }

    public boolean isOutOfDate(long var1);

    public double rangeSpanned(Range<Token> var1);

    public double localSpaceCoverage();

    public double shardSetCoverage();

    public ShardTracker boundaries(int var1);

    public static Range<Token> coveringRange(SSTableReader sstable) {
        return ShardManager.coveringRange(sstable.getFirst(), sstable.getLast());
    }

    public static Range<Token> coveringRange(PartitionPosition first, PartitionPosition last) {
        return new Range<Token>(first.getToken(), last.getToken().nextValidToken());
    }

    default public double rangeSpanned(SSTableReader rdr) {
        double reported = rdr.tokenSpaceCoverage();
        double span = reported > 0.0 ? reported : this.rangeSpanned(rdr.getFirst(), rdr.getLast());
        if (span >= MINIMUM_TOKEN_COVERAGE) {
            return span;
        }
        return 1.0;
    }

    default public double rangeSpanned(PartitionPosition first, PartitionPosition last) {
        return this.rangeSpanned(ShardManager.coveringRange(first, last));
    }

    default public double density(SSTableReader rdr) {
        return (double)rdr.onDiskLength() / this.rangeSpanned(rdr);
    }

    default public int compareByDensity(SSTableReader a, SSTableReader b) {
        return Double.compare(this.density(a), this.density(b));
    }

    default public double calculateCombinedDensity(Set<? extends SSTableReader> sstables) {
        if (sstables.isEmpty()) {
            return 0.0;
        }
        long onDiskLength = 0L;
        Comparable min2 = null;
        Comparable max = null;
        for (SSTableReader sSTableReader : sstables) {
            onDiskLength += sSTableReader.onDiskLength();
            min2 = min2 == null || min2.compareTo(sSTableReader.getFirst()) > 0 ? sSTableReader.getFirst() : min2;
            max = max == null || max.compareTo(sSTableReader.getLast()) < 0 ? sSTableReader.getLast() : max;
        }
        double span = this.rangeSpanned((PartitionPosition)min2, (PartitionPosition)max);
        if (span >= MINIMUM_TOKEN_COVERAGE) {
            return (double)onDiskLength / span;
        }
        return onDiskLength;
    }
}

