/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.ArrayListMultimap;
import io.airlift.airline.Command;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;
import org.apache.cassandra.tools.nodetool.SetHostStatWithPort;

@Command(name="describecluster", description="Print the name, snitch, partitioner and schema version of a cluster")
public class DescribeCluster
extends NodeTool.NodeToolCmd {
    private boolean resolveIp = false;
    private String keyspace = null;
    private Collection<String> joiningNodes;
    private Collection<String> leavingNodes;
    private Collection<String> movingNodes;
    private Collection<String> liveNodes;
    private Collection<String> unreachableNodes;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.println("Cluster Information:");
        out.println("\tName: " + probe.getClusterName());
        String snitch = probe.getEndpointSnitchInfoProxy().getSnitchName();
        boolean dynamicSnitchEnabled = false;
        if (snitch.equals(DynamicEndpointSnitch.class.getName())) {
            snitch = probe.getDynamicEndpointSnitchInfoProxy().getSubsnitchClassName();
            dynamicSnitchEnabled = true;
        }
        out.println("\tSnitch: " + snitch);
        out.println("\tDynamicEndPointSnitch: " + (dynamicSnitchEnabled ? "enabled" : "disabled"));
        out.println("\tPartitioner: " + probe.getPartitioner());
        out.println("\tSchema versions:");
        Map<String, List<String>> schemaVersions = this.printPort ? probe.getSpProxy().getSchemaVersionsWithPort() : probe.getSpProxy().getSchemaVersions();
        for (Map.Entry<String, List<String>> entry : schemaVersions.entrySet()) {
            out.printf("\t\t%s: %s%n%n", entry.getKey(), entry.getValue());
        }
        boolean withPort = true;
        this.joiningNodes = probe.getJoiningNodes(withPort);
        this.leavingNodes = probe.getLeavingNodes(withPort);
        this.movingNodes = probe.getMovingNodes(withPort);
        this.liveNodes = probe.getLiveNodes(withPort);
        this.unreachableNodes = probe.getUnreachableNodes(withPort);
        List<String> keyspaces = probe.getKeyspaces();
        out.println("Stats for all nodes:");
        out.println("\tLive: " + this.liveNodes.size());
        out.println("\tJoining: " + this.joiningNodes.size());
        out.println("\tMoving: " + this.movingNodes.size());
        out.println("\tLeaving: " + this.leavingNodes.size());
        out.println("\tUnreachable: " + this.unreachableNodes.size());
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap(withPort);
        StringBuilder errors = new StringBuilder();
        Map<String, Float> ownerships = null;
        try {
            ownerships = probe.effectiveOwnershipWithPort(this.keyspace);
        }
        catch (IllegalStateException ex) {
            try {
                ownerships = probe.getOwnershipWithPort();
                errors.append("Note: ").append(ex.getMessage()).append("%n");
            }
            catch (Exception e) {
                out.printf("%nError: %s%n", e.getMessage());
                System.exit(1);
            }
        }
        catch (IllegalArgumentException ex) {
            out.printf("%nError: %s%n", ex.getMessage());
            System.exit(1);
        }
        SortedMap<String, SetHostStatWithPort> dcs = NodeTool.getOwnershipByDcWithPort(probe, this.resolveIp, tokensToEndpoints, ownerships);
        out.println("\nData Centers: ");
        for (Map.Entry<String, SetHostStatWithPort> dc : dcs.entrySet()) {
            out.print("\t" + dc.getKey());
            ArrayListMultimap hostToTokens = ArrayListMultimap.create();
            for (HostStatWithPort stat : dc.getValue()) {
                hostToTokens.put(stat.endpointWithPort, stat);
            }
            int totalNodes = 0;
            int downNodes = 0;
            for (InetAddressAndPort endpoint : hostToTokens.keySet()) {
                ++totalNodes;
                if (!this.unreachableNodes.contains(endpoint.getHostAddressAndPort())) continue;
                ++downNodes;
            }
            out.print(" #Nodes: " + totalNodes);
            out.println(" #Down: " + downNodes);
        }
        out.println("\nDatabase versions:");
        Map<String, List<String>> databaseVersions = probe.getGossProxy().getReleaseVersionsWithPort();
        for (Map.Entry<String, List<String>> entry : databaseVersions.entrySet()) {
            out.printf("\t%s: %s%n%n", entry.getKey(), entry.getValue());
        }
        out.println("Keyspaces:");
        for (String keyspaceName : keyspaces) {
            String replicationInfo = probe.getKeyspaceReplicationInfo(keyspaceName);
            if (replicationInfo == null) {
                out.println("something went wrong for keyspace: " + keyspaceName);
            }
            out.printf("\t%s -> Replication class: %s%n", keyspaceName, replicationInfo);
        }
        if (errors.length() != 0) {
            out.printf("%n" + errors, new Object[0]);
        }
    }
}

