/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.Map;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.utils.JsonUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public interface StatsPrinter<T extends StatsHolder> {
    public void print(T var1, PrintStream var2);

    public static class YamlPrinter<T extends StatsHolder>
    implements StatsPrinter<T> {
        @Override
        public void print(T data, PrintStream out) {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            out.println(yaml.dump(data.convert2Map()));
        }
    }

    public static class JsonPrinter<T extends StatsHolder>
    implements StatsPrinter<T> {
        @Override
        public void print(T data, PrintStream out) {
            Map<String, Object> stats = data.convert2Map();
            for (Object statEntry : stats.values()) {
                if (!(statEntry instanceof Map)) continue;
                for (Map.Entry entry : ((Map)statEntry).entrySet()) {
                    if (!(entry.getValue() instanceof Double) || Double.isFinite((Double)entry.getValue())) continue;
                    entry.setValue(null);
                }
            }
            out.println(JsonUtils.writeAsPrettyJsonString(stats));
        }
    }
}

