/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedInts;

public class CassandraUInt {
    public static final long MAX_VALUE_LONG = UnsignedInteger.MAX_VALUE.longValue();
    public static final int MAX_VALUE_UINT = UnsignedInteger.MAX_VALUE.intValue();

    public static int fromLong(long value) {
        return UnsignedInts.checkedCast(value);
    }

    public static int[] fromLong(long[] values) {
        int[] delTimesUints = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            delTimesUints[i] = CassandraUInt.fromLong(values[i]);
        }
        return delTimesUints;
    }

    public static long toLong(int value) {
        return UnsignedInts.toLong(value);
    }

    public static int compare(int x, int y) {
        return UnsignedInts.compare(x, y);
    }
}

