/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.github.jamm.CannotAccessFieldException;
import org.github.jamm.FieldAndClassFilter;
import org.github.jamm.FieldFilter;
import org.github.jamm.Filters;
import org.github.jamm.Measurable;
import org.github.jamm.MeasurementStack;
import org.github.jamm.MemoryLayoutSpecification;
import org.github.jamm.MemoryMeterListener;
import org.github.jamm.MemoryMeterStrategy;
import org.github.jamm.accessors.FieldAccessor;
import org.github.jamm.listeners.NoopMemoryMeterListener;
import org.github.jamm.listeners.TreePrinter;
import org.github.jamm.strategies.MemoryMeterStrategies;
import org.github.jamm.string.StringMeter;
import org.github.jamm.utils.ByteBufferMeasurementUtils;

public final class MemoryMeter {
    public static final List<Guess> BEST = Collections.unmodifiableList(Arrays.asList(Guess.INSTRUMENTATION, Guess.UNSAFE, Guess.SPECIFICATION));
    private static final FieldAccessor ACCESSOR = FieldAccessor.newInstance();
    private final MemoryMeterStrategy strategy;
    private final FieldAndClassFilter classFilter;
    private final FieldFilter fieldFilter;
    private final StringMeter STRING_METER = StringMeter.newInstance();
    private final MemoryMeterListener.Factory listenerFactory;

    public static void premain(String options, Instrumentation inst) {
        MemoryMeterStrategies.instrumentation = inst;
    }

    public static void agentmain(String options, Instrumentation inst) {
        MemoryMeterStrategies.instrumentation = inst;
    }

    public static boolean hasInstrumentation() {
        return MemoryMeterStrategies.getInstance().hasInstrumentation();
    }

    public static boolean hasUnsafe() {
        return MemoryMeterStrategies.getInstance().hasUnsafe();
    }

    public static boolean useStringOptimization() {
        return StringMeter.ENABLED;
    }

    private MemoryMeter(Builder builder) {
        this(MemoryMeterStrategies.getInstance().getStrategy(builder.guesses), Filters.getClassFilters(builder.ignoreKnownSingletons), Filters.getFieldFilters(builder.ignoreKnownSingletons, builder.ignoreOuterClassReference, builder.ignoreNonStrongReferences), builder.listenerFactory);
    }

    public MemoryMeter(MemoryMeterStrategy strategy, FieldAndClassFilter classFilter, FieldFilter fieldFilter, MemoryMeterListener.Factory listenerFactory) {
        this.strategy = strategy;
        this.classFilter = classFilter;
        this.fieldFilter = fieldFilter;
        this.listenerFactory = listenerFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MemoryLayoutSpecification getMemoryLayoutSpecification() {
        return MemoryMeterStrategy.MEMORY_LAYOUT;
    }

    public long measure(Object object) {
        if (object == null) {
            return 0L;
        }
        return this.strategy.measure(object);
    }

    public long measureArray(Object[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(byte[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(boolean[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(short[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(char[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(int[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(float[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(double[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureArray(long[] array) {
        if (array == null) {
            return 0L;
        }
        return this.strategy.measureArray(array);
    }

    public long measureStringDeep(String s2) {
        if (StringMeter.ENABLED) {
            if (s2 == null) {
                return 0L;
            }
            return this.STRING_METER.measureDeep(this.strategy, s2);
        }
        return this.measureDeep(s2);
    }

    public long measureDeep(Object object) {
        return this.measureDeep(object, ByteBufferMode.NORMAL);
    }

    public long measureDeep(Object object, ByteBufferMode bbMode) {
        if (object == null) {
            return 0L;
        }
        if (this.classFilter.ignore(object.getClass())) {
            return 0L;
        }
        MemoryMeterListener listener = this.listenerFactory.newInstance();
        MeasurementStack stack = new MeasurementStack(this.classFilter, listener);
        stack.pushRoot(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            if (StringMeter.ENABLED && current instanceof String) {
                String s2 = (String)current;
                long size1 = this.measureDeep(s2, listener);
                total += size1;
                continue;
            }
            if (current instanceof Measurable) {
                Measurable measurable = (Measurable)current;
                total += this.measure(measurable, listener);
                measurable.addChildrenTo(stack);
                continue;
            }
            long size = this.strategy.measure(current);
            listener.objectMeasured(current, size);
            total += size;
            Class<?> cls = current.getClass();
            if (cls.isArray()) {
                if (cls.getComponentType().isPrimitive()) continue;
                this.addArrayElements((Object[])current, stack);
                continue;
            }
            if (current instanceof ByteBuffer && bbMode.isSlab((ByteBuffer)current)) {
                ByteBuffer buffer = (ByteBuffer)current;
                if (buffer.isDirect()) continue;
                long remaining = buffer.remaining();
                listener.byteBufferRemainingMeasured(buffer, remaining);
                total += remaining;
                continue;
            }
            this.addFields(current, cls, stack);
        }
        listener.done(total);
        return total;
    }

    private long measureDeep(String s2, MemoryMeterListener listener) {
        long size = this.STRING_METER.measureDeep(this.strategy, s2);
        listener.objectMeasured(s2, size);
        return size;
    }

    private long measure(Measurable measurable, MemoryMeterListener listener) {
        long size = measurable.shallowSize(this.strategy);
        listener.objectMeasured(measurable, size);
        return size;
    }

    private void addFields(Object obj, Class<?> cls, MeasurementStack stack) {
        for (Class<?> type = cls; type != null; type = type.getSuperclass()) {
            this.addDeclaredFields(obj, type, stack);
        }
    }

    private void addDeclaredFields(Object obj, Class<?> type, MeasurementStack stack) {
        for (Field field : type.getDeclaredFields()) {
            if (this.fieldFilter.ignore(obj.getClass(), field)) continue;
            this.addField(obj, field, stack);
        }
    }

    private void addField(Object obj, Field field, MeasurementStack stack) {
        Object child = this.getFieldValue(obj, field, stack.listener());
        if (child != null && !this.classFilter.ignore(child.getClass())) {
            stack.pushObject(obj, field.getName(), child);
        }
    }

    private Object getFieldValue(Object obj, Field field, MemoryMeterListener listener) {
        try {
            return ACCESSOR.getFieldValue(obj, field);
        }
        catch (CannotAccessFieldException e) {
            listener.failedToAccessField(obj, field.getName(), field.getType());
            throw e;
        }
    }

    private void addArrayElements(Object[] array, MeasurementStack stack) {
        for (int i = 0; i < array.length; ++i) {
            stack.pushArrayElement(array, i);
        }
    }

    public static final class Builder {
        private List<Guess> guesses = BEST;
        private boolean ignoreOuterClassReference;
        private boolean ignoreKnownSingletons = true;
        private boolean ignoreNonStrongReferences = true;
        private MemoryMeterListener.Factory listenerFactory = NoopMemoryMeterListener.FACTORY;

        private Builder() {
        }

        public MemoryMeter build() {
            return new MemoryMeter(this);
        }

        public Builder withGuessing(Guess strategy, Guess ... fallbacks) {
            if (strategy == null) {
                throw new IllegalArgumentException("The strategy parameter should not be null");
            }
            ArrayList<Guess> guesseList = new ArrayList<Guess>();
            guesseList.add(strategy);
            for (Guess guess : fallbacks) {
                guesseList.add(guess);
            }
            Guess.checkOrder(guesseList);
            this.guesses = guesseList;
            return this;
        }

        public Builder ignoreOuterClassReference() {
            this.ignoreOuterClassReference = true;
            return this;
        }

        public Builder measureKnownSingletons() {
            this.ignoreKnownSingletons = false;
            return this;
        }

        public Builder measureNonStrongReferences() {
            this.ignoreNonStrongReferences = false;
            return this;
        }

        public Builder printVisitedTree() {
            return this.printVisitedTreeUpTo(Integer.MAX_VALUE);
        }

        public Builder printVisitedTreeUpTo(int depth) {
            if (depth <= 0) {
                throw new IllegalArgumentException(String.format("the depth must be greater than zero (was %s).", depth));
            }
            this.listenerFactory = new TreePrinter.Factory(depth);
            return this;
        }
    }

    public static enum ByteBufferMode {
        NORMAL{

            @Override
            public boolean isSlab(ByteBuffer buffer) {
                return false;
            }
        }
        ,
        SLAB_ALLOCATION_NO_SLICE{

            @Override
            public boolean isSlab(ByteBuffer buffer) {
                return buffer.capacity() > buffer.remaining();
            }
        }
        ,
        SLAB_ALLOCATION_SLICE{

            @Override
            public boolean isSlab(ByteBuffer buffer) {
                return buffer.capacity() < ByteBufferMeasurementUtils.underlyingCapacity(buffer, ACCESSOR);
            }
        };


        public abstract boolean isSlab(ByteBuffer var1);
    }

    public static enum Guess {
        INSTRUMENTATION{

            @Override
            public boolean requireInstrumentation() {
                return true;
            }
        }
        ,
        INSTRUMENTATION_AND_SPECIFICATION{

            @Override
            public boolean requireInstrumentation() {
                return true;
            }
        }
        ,
        UNSAFE{

            @Override
            public boolean requireUnsafe() {
                return true;
            }

            @Override
            public boolean canBeUsedAsFallbackFrom(Guess strategy) {
                return strategy.requireInstrumentation();
            }
        }
        ,
        SPECIFICATION{

            @Override
            public boolean requireUnsafe() {
                return true;
            }

            @Override
            public boolean canBeUsedAsFallbackFrom(Guess guess) {
                return true;
            }
        };


        public boolean requireInstrumentation() {
            return false;
        }

        public boolean requireUnsafe() {
            return false;
        }

        public boolean canBeUsedAsFallbackFrom(Guess guess) {
            return false;
        }

        public static void checkOrder(List<Guess> guesses) {
            Guess previous = null;
            for (Guess guess : guesses) {
                if (previous != null && !guess.canBeUsedAsFallbackFrom(previous)) {
                    throw new IllegalArgumentException("The " + (Object)((Object)guess) + " strategy cannot be used as fallback for the " + (Object)((Object)previous) + " strategy.");
                }
                previous = guess;
            }
        }
    }
}

