/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class IndentParser {
    public static String POPUP = "POPUP";
    List<Object> resultStack = new ArrayList<Object>();
    List<Integer> indentStack = new ArrayList<Integer>();
    List<ParseState> parseStateStack = new ArrayList<ParseState>();
    int lineNumber;
    int lineIndent;

    protected IndentParser() {
        this.reset();
    }

    public void push(String line) throws ParseException {
        ++this.lineNumber;
        if (this.isEmpty(line)) {
            return;
        }
        int n = this.lineIndent = this.indentOf(line);
        String token = line.substring(n, line.length());
        if (this.isIndentPending()) {
            if (n > this.lastIndent()) {
                this.updateIndent(n);
                this.pushToken(token);
            } else if (n == this.lastIndent()) {
                this.indentPopup();
                this.pushToken(token);
            } else {
                this.popupTo(n);
                this.pushToken(token);
            }
        } else if (n == this.lastIndent()) {
            this.pushToken(token);
        } else {
            this.popupTo(n);
            this.pushToken(token);
        }
        if (this.parseState().expectedPatterns.isEmpty()) {
            throw new ParseException("Internal error: Parsing dead end", this.lineNumber, line.length() - 1);
        }
    }

    public void finish() throws ParseException {
        try {
            for (int i = 0; i != this.indentStack.size(); ++i) {
                this.sendPopup();
            }
            this.indentStack.clear();
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("Parse error: " + e.toString(), this.lineNumber + 1, 0);
        }
    }

    private boolean isIndentPending() {
        return this.indentStack.get(this.indentStack.size() - 1) == -1;
    }

    private void updateIndent(int n) {
        if (!this.isIndentPending()) {
            throw new IllegalArgumentException();
        }
        this.indentStack.set(this.indentStack.size() - 1, n);
    }

    private int lastIndent() {
        if (this.isIndentPending()) {
            return this.indentStack.size() == 1 ? -1 : this.indentStack.get(this.indentStack.size() - 2);
        }
        return this.indentStack.get(this.indentStack.size() - 1);
    }

    private void popupTo(int n) throws ParseException {
        while (true) {
            int m4;
            if ((m4 = this.indentStack.remove(this.indentStack.size() - 1).intValue()) == -1) {
                this.sendPopup();
                m4 = this.indentStack.remove(this.indentStack.size() - 1);
            }
            if (m4 == n) {
                this.indentStack.add(m4);
                return;
            }
            if (m4 < n) {
                throw new ParseException("Invalid indenation alignment, expected is " + m4, this.lineNumber, n);
            }
            if (this.indentStack.size() == 0) {
                throw new ParseException("Invalid indenation alignment, expected is " + m4, this.lineNumber, n);
            }
            this.sendPopup();
        }
    }

    private void pushToken(String token) throws ParseException {
        for (String tk : this.parseState().expectedPatterns.keySet()) {
            String ptr = this.parseState().expectedPatterns.get(tk);
            if (ptr.length() <= 0 || !token.matches(ptr)) continue;
            this.onToken(tk, token);
            return;
        }
        throw new ParseException("Line is not expected. Expected " + this.parseState().getExpectedTokensHint() + ", line: " + token, this.lineNumber, this.lineIndent);
    }

    private void indentPopup() throws ParseException {
        this.indentStack.remove(this.indentStack.size() - 1);
        this.sendPopup();
    }

    private void sendPopup() throws ParseException {
        if (!this.parseState().expectedPatterns.containsKey(POPUP)) {
            throw new ParseException("Unexpected unindent, expected " + this.parseState().getExpectedTokensHint(), this.lineNumber, this.lineIndent);
        }
        this.onPopup();
    }

    protected int indentOf(String line) throws ParseException {
        for (int i = 0; i != line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == ' ') continue;
            if (!Character.isWhitespace(ch)) {
                return i;
            }
            throw new ParseException("Unallowed char 0x" + Integer.toHexString(ch), this.lineNumber, i);
        }
        throw new IllegalArgumentException("Line is empty");
    }

    protected boolean isEmpty(String line) {
        return (line = line.trim()).startsWith("#") || line.length() == 0;
    }

    public void reset() {
        this.resultStack.clear();
        this.indentStack.clear();
        this.indentStack.add(0);
        this.parseStateStack.clear();
        this.parseStateStack.add(new ParseState());
        this.initialState();
    }

    protected abstract void initialState();

    protected abstract void onToken(String var1, String var2) throws ParseException;

    protected abstract void onPopup() throws ParseException;

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getIndent() {
        return this.lastIndent();
    }

    public Map<String, String> getExpectedTokens() {
        return this.parseState().expectedTokens();
    }

    private ParseState parseState() {
        return this.parseStateStack.get(this.parseStateStack.size() - 1);
    }

    protected void error(String message) throws ParseException {
        throw new ParseException(message, this.lineNumber, this.lineIndent);
    }

    protected void pushParseState() {
        this.indentStack.add(-1);
        this.parseStateStack.add(new ParseState());
    }

    protected void popParseState() {
        this.parseStateStack.remove(this.parseStateStack.size() - 1);
    }

    protected Object value() {
        return this.resultStack.get(this.resultStack.size() - 1);
    }

    protected void pushValue(Object value) {
        this.resultStack.add(value);
    }

    protected Object popValue() {
        return this.resultStack.remove(this.resultStack.size() - 1);
    }

    protected void expectToken(String id, String pattern) {
        this.parseState().expectToken(id, pattern);
    }

    protected void unexpectToken(String id) {
        this.parseState().unexpectToken(id);
    }

    protected void expectPopup() {
        this.parseState().expectToken(POPUP, "");
    }

    protected void unexpectPopup() {
        this.parseState().unexpectToken(POPUP);
    }

    protected void unexpectAll() {
        this.parseState().expectedPatterns.clear();
    }

    public static class ParseException
    extends Exception {
        private int line;
        private int position;

        public ParseException(String message, int line, int position) {
            super(message);
            this.line = line;
            this.position = position;
        }

        public ParseException(String message, int line, int position, Throwable cause) {
            super(message, cause);
            this.line = line;
            this.position = position;
        }

        public int getLine() {
            return this.line;
        }

        public int getPosition() {
            return this.position;
        }
    }

    protected static class ParseState {
        Map<String, String> expectedPatterns = new LinkedHashMap<String, String>();

        protected ParseState() {
        }

        public Map<String, String> expectedTokens() {
            return new LinkedHashMap<String, String>(this.expectedPatterns);
        }

        public String getExpectedTokensHint() {
            ArrayList<String> tokens = new ArrayList<String>(this.expectedPatterns.keySet());
            Collections.sort(tokens);
            return ((Object)tokens).toString();
        }

        public void expectToken(String name, String pattern) {
            this.expectedPatterns.put(name, pattern);
        }

        public void unexpectToken(String name) {
            this.expectedPatterns.remove(name);
        }
    }
}

