/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.exception.ResourceNotFoundException;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.http.SidecarHttpResponseStatus;
import org.apache.cassandra.sidecar.common.request.Request;

public class BasicRetryPolicy
extends RetryPolicy {
    protected static final String RETRY_AFTER = "Retry-After";
    public static final int RETRY_INDEFINITELY = -1;
    protected final int maxRetries;
    protected final long retryDelayMillis;

    public BasicRetryPolicy() {
        this(-1, 0L);
    }

    public BasicRetryPolicy(int maxRetries) {
        this(maxRetries, 0L);
    }

    public BasicRetryPolicy(int maxRetries, long retryDelayMillis) {
        this.maxRetries = maxRetries;
        this.retryDelayMillis = retryDelayMillis;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (throwable != null || response.statusCode() == HttpResponseStatus.INTERNAL_SERVER_ERROR.code()) {
            if (canRetryOnADifferentHost) {
                this.retryImmediately(responseFuture, request, response, retryAction, attempts, throwable);
            } else {
                this.retry(responseFuture, request, response, retryAction, attempts, throwable);
            }
            return;
        }
        if (response.statusCode() == HttpResponseStatus.OK.code() || response.statusCode() == HttpResponseStatus.PARTIAL_CONTENT.code()) {
            responseFuture.complete(response);
            return;
        }
        if (response.statusCode() == HttpResponseStatus.NOT_FOUND.code()) {
            if (canRetryOnADifferentHost) {
                this.retryImmediately(responseFuture, request, response, retryAction, attempts);
            } else {
                this.logger.error("Request resource not found. response={}, attempts={}", (Object)response, (Object)attempts);
                responseFuture.completeExceptionally(new ResourceNotFoundException(request));
            }
            return;
        }
        if (response.statusCode() == HttpResponseStatus.NOT_IMPLEMENTED.code()) {
            this.logger.error("Request to a not implemented endpoint. response={}, attempts={}", (Object)response, (Object)attempts);
            responseFuture.completeExceptionally(this.unsupportedOperation(response));
            return;
        }
        if (response.statusCode() == HttpResponseStatus.SERVICE_UNAVAILABLE.code()) {
            if (canRetryOnADifferentHost) {
                this.retryImmediately(responseFuture, request, response, retryAction, attempts);
            } else {
                this.retry(responseFuture, request, response, retryAction, attempts, this.maybeParseRetryAfterOrDefault(response, attempts), null);
            }
            return;
        }
        if (response.statusCode() == HttpResponseStatus.ACCEPTED.code()) {
            retryAction.retry(1, this.retryDelayMillis(1));
            return;
        }
        if (response.statusCode() == SidecarHttpResponseStatus.CHECKSUM_MISMATCH.code()) {
            if (canRetryOnADifferentHost) {
                this.retryImmediately(responseFuture, request, response, retryAction, attempts);
            } else {
                this.retry(responseFuture, request, response, retryAction, attempts, null);
            }
            return;
        }
        if (HttpStatusClass.CLIENT_ERROR.contains(response.statusCode()) || HttpStatusClass.SERVER_ERROR.contains(response.statusCode())) {
            if (canRetryOnADifferentHost) {
                this.retryImmediately(responseFuture, request, response, retryAction, attempts);
            } else {
                this.logger.error("Request exhausted. response={}, attempts={}", (Object)response, (Object)attempts);
                responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response));
            }
            return;
        }
        this.logger.error("Request encountered an unexpected status code. response={}, attempts={}", (Object)response, (Object)attempts);
        responseFuture.completeExceptionally(this.unexpectedStatusCode(response));
    }

    protected int maxRetries() {
        return this.maxRetries;
    }

    protected long retryDelayMillis(int attempts) {
        return this.retryDelayMillis;
    }

    protected void retryImmediately(CompletableFuture<HttpResponse> future, Request request, HttpResponse lastResponse, RetryAction retryAction, int attempts) {
        this.retry(future, request, lastResponse, retryAction, attempts, 0L, null);
    }

    protected void retryImmediately(CompletableFuture<HttpResponse> future, Request request, HttpResponse lastResponse, RetryAction retryAction, int attempts, Throwable throwable) {
        this.retry(future, request, lastResponse, retryAction, attempts, 0L, throwable);
    }

    protected void retry(CompletableFuture<HttpResponse> future, Request request, HttpResponse lastResponse, RetryAction retryAction, int attempts, Throwable throwable) {
        this.retry(future, request, lastResponse, retryAction, attempts, this.retryDelayMillis(attempts), throwable);
    }

    protected void retry(CompletableFuture<HttpResponse> future, Request request, HttpResponse lastResponse, RetryAction retryAction, int attempts, long sleepTimeMillis, Throwable throwable) {
        int configuredMaxRetries = this.maxRetries();
        if (configuredMaxRetries > -1 && attempts >= configuredMaxRetries) {
            future.completeExceptionally(RetriesExhaustedException.of(attempts, request, lastResponse, throwable));
        } else {
            retryAction.retry(attempts + 1, sleepTimeMillis);
        }
    }

    protected long maybeParseRetryAfterOrDefault(HttpResponse response, int attempts) {
        List<String> retryAfter = response.headers().get(RETRY_AFTER);
        if (retryAfter != null && !retryAfter.isEmpty()) {
            try {
                long seconds = Long.parseLong(retryAfter.get(0));
                return TimeUnit.SECONDS.toMillis(seconds);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Failed to parse header={}, value={}", new Object[]{RETRY_AFTER, retryAfter.get(0), e});
            }
        }
        return this.retryDelayMillis(attempts);
    }
}

