/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class DurationSpec
implements Comparable<DurationSpec> {
    private static final Pattern UNITS_PATTERN = Pattern.compile("^(\\d+)(d|h|s|ms|m)$");
    private final long quantity;
    private final TimeUnit unit;

    protected DurationSpec(String value) throws IllegalArgumentException {
        Matcher matcher = UNITS_PATTERN.matcher(value);
        if (!matcher.find()) {
            throw this.iae(value);
        }
        this.quantity = Long.parseLong(matcher.group(1));
        this.unit = DurationSpec.fromSymbol(matcher.group(2));
        this.validateMinUnit(value, this.unit, this.minimumUnit());
        this.validateQuantity(value, this.quantity, this.unit, this.minimumUnit());
    }

    protected DurationSpec(long quantity, TimeUnit unit) throws IllegalArgumentException {
        this.quantity = quantity;
        this.unit = unit;
        this.validateMinUnit(this, unit, this.minimumUnit());
        this.validateQuantity(this, quantity, unit, this.minimumUnit());
    }

    public abstract TimeUnit minimumUnit();

    public long quantity() {
        return this.quantity;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public long to(TimeUnit targetUnit) {
        return targetUnit.convert(this.quantity(), this.unit());
    }

    public long toSeconds() {
        return this.to(TimeUnit.SECONDS);
    }

    public long toMillis() {
        return this.to(TimeUnit.MILLISECONDS);
    }

    public int toIntMillis() {
        long longMillis = this.toMillis();
        if (longMillis > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)longMillis;
    }

    public int hashCode() {
        return Objects.hash(this.toMillis());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DurationSpec)) {
            return false;
        }
        DurationSpec that = (DurationSpec)obj;
        if (this.unit == that.unit()) {
            return this.quantity == that.quantity();
        }
        return this.unit.convert(that.quantity(), that.unit()) == this.quantity && that.unit().convert(this.quantity, this.unit) == that.quantity();
    }

    public String toString() {
        return this.quantity + DurationSpec.symbol(this.unit);
    }

    @Override
    public int compareTo(@NotNull DurationSpec that) {
        if (this.unit == that.unit()) {
            return Long.compare(this.quantity, that.quantity());
        }
        TimeUnit minUnit = this.unit.compareTo(that.unit()) < 0 ? this.unit : that.unit();
        return Long.compare(this.to(minUnit), that.to(minUnit));
    }

    void validateMinUnit(Object value, TimeUnit unit, TimeUnit minUnit) {
        if (unit.compareTo(minUnit) < 0) {
            throw this.iae(value);
        }
    }

    void validateQuantity(Object value, long quantity, TimeUnit sourceUnit, TimeUnit minUnit) {
        if (quantity < 0L) {
            throw this.iae(value);
        }
        if (minUnit.convert(quantity, sourceUnit) == Long.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Invalid duration: %s. It shouldn't be more than %d in %s", value, 0x7FFFFFFFFFFFFFFEL, minUnit.name().toLowerCase()));
        }
    }

    IllegalArgumentException iae(Object value) {
        return new IllegalArgumentException(String.format("Invalid duration %s. Positive numbers with units %s are allowed", value, DurationSpec.acceptedUnits(this.minimumUnit())));
    }

    public static String symbol(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return "d";
            }
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "m";
            }
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
        }
        throw new IllegalArgumentException("Unsupported unit " + unit);
    }

    public static TimeUnit fromSymbol(String symbol) {
        switch (symbol.toLowerCase()) {
            case "d": {
                return TimeUnit.DAYS;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported time unit: %s. Supported units are: %s", symbol, Arrays.stream(TimeUnit.values()).map(DurationSpec::symbol).collect(Collectors.joining(", "))));
    }

    static String acceptedUnits(TimeUnit minimumUnit) {
        TimeUnit[] units = TimeUnit.values();
        return Arrays.stream(Arrays.copyOfRange(units, minimumUnit.ordinal(), units.length)).map(unit -> DurationSpec.symbol(unit) + "(" + unit.name().toLowerCase() + ")").collect(Collectors.joining(", ", "[", "]"));
    }
}

