/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.AuthCache;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.SidecarPermissionsDatabaseAccessor;
import org.apache.cassandra.sidecar.db.SystemAuthDatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;

@Singleton
public class RoleAuthorizationsCache
extends AuthCache<String, Map<String, Set<Authorization>>> {
    private static final String NAME = "role_permissions_cache";
    protected static final String UNIQUE_CACHE_ENTRY = "unique_cache_entry_key";

    @Inject
    public RoleAuthorizationsCache(Vertx vertx, ExecutorPools executorPools, SidecarConfiguration sidecarConfiguration, SidecarSchema sidecarSchema, SystemAuthDatabaseAccessor systemAuthDatabaseAccessor, SidecarPermissionsDatabaseAccessor sidecarPermissionsDatabaseAccessor) {
        super(NAME, vertx, executorPools, (K k) -> RoleAuthorizationsCache.loadAuthorizations(systemAuthDatabaseAccessor, sidecarSchema, sidecarPermissionsDatabaseAccessor), () -> Collections.singletonMap(UNIQUE_CACHE_ENTRY, RoleAuthorizationsCache.loadAuthorizations(systemAuthDatabaseAccessor, sidecarSchema, sidecarPermissionsDatabaseAccessor)), sidecarConfiguration.accessControlConfiguration().permissionCacheConfiguration());
    }

    @Override
    public Map<String, Set<Authorization>> get(String ignored) {
        return (Map)super.get(UNIQUE_CACHE_ENTRY);
    }

    public Set<Authorization> getAuthorizations(String role) {
        Map<String, Set<Authorization>> roleAuthorizations = this.get(UNIQUE_CACHE_ENTRY);
        return roleAuthorizations != null ? roleAuthorizations.get(role) : Collections.emptySet();
    }

    private static Map<String, Set<Authorization>> loadAuthorizations(SystemAuthDatabaseAccessor systemAuthDatabaseAccessor, SidecarSchema sidecarSchema, SidecarPermissionsDatabaseAccessor sidecarPermissionsDatabaseAccessor) {
        Map<String, Set<Authorization>> roleAuthorizations = systemAuthDatabaseAccessor.findAllRolesAndPermissions();
        if (sidecarSchema.isInitialized()) {
            Map<String, Set<Authorization>> sidecarAuthorizations = sidecarPermissionsDatabaseAccessor.rolesToAuthorizations();
            sidecarAuthorizations.forEach((role, authorizations) -> roleAuthorizations.merge((String)role, (Set<Authorization>)authorizations, (existingAuthorizations, newAuthorizations) -> {
                existingAuthorizations.addAll(newAuthorizations);
                return existingAuthorizations;
            }));
        }
        return roleAuthorizations;
    }
}

