/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import org.apache.cassandra.sidecar.acl.authorization.Permission;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScope;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.common.utils.StringUtils;

public class StandardPermission
implements Permission {
    protected final String name;
    protected final ResourceScope resourceScope;

    public StandardPermission(String name) {
        this(name, ResourceScopes.NO_SCOPE);
    }

    public StandardPermission(String name, ResourceScope scope) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Permission name can not be null or empty");
        }
        this.name = name;
        this.resourceScope = scope;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ResourceScope resourceScope() {
        return this.resourceScope;
    }

    @Override
    public Authorization toAuthorization(String resource) {
        PermissionBasedAuthorization authorization = PermissionBasedAuthorization.create((String)this.name);
        if (StringUtils.isNotEmpty((String)resource)) {
            authorization.setResource(this.resourceScope.resolveWithResource(resource));
        }
        return authorization;
    }
}

