/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.mxe.MetadataChangeProposal;
import datahub.client.Callback;
import datahub.client.Emitter;
import datahub.client.MetadataWriteResponse;
import datahub.event.EventFormatter;
import datahub.event.MetadataChangeProposalWrapper;
import datahub.event.UpsertAspectRequest;
import datahub.shaded.jackson.annotation.JsonInclude;
import datahub.shaded.jackson.core.PrettyPrinter;
import datahub.shaded.jackson.core.util.DefaultIndenter;
import datahub.shaded.jackson.core.util.DefaultPrettyPrinter;
import datahub.shaded.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonEmitter
implements Emitter,
AutoCloseable {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final String OPEN = "[";
    private static final String INDENT = "\t";
    private static final String LINE = "\n";
    private static final String COMMA = ",";
    private static final String CLOSE = "]";
    private static final DefaultPrettyPrinter.Indenter INDENTER = new DefaultIndenter("\t", "\n");
    private static final PrettyPrinter PRINTER = new DefaultPrettyPrinter().withObjectIndenter(INDENTER).withArrayIndenter(INDENTER);
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final JacksonDataTemplateCodec CODEC = new JacksonDataTemplateCodec(MAPPER.getFactory());
    private static final EventFormatter FORMATTER = new EventFormatter();
    private static final Future<MetadataWriteResponse> SUCCESS = CompletableFuture.completedFuture(null);
    private final StringBuilder json = new StringBuilder(0x100000);

    public JsonEmitter() {
        this.json.append(OPEN);
    }

    public synchronized boolean testConnection() {
        throw new UnsupportedOperationException(this.getClass() + " does not support testConnection() operation");
    }

    @NotNull
    public synchronized Future<MetadataWriteResponse> emit(@NotNull List<UpsertAspectRequest> requests, @Nullable Callback callback) {
        throw new UnsupportedOperationException(this.getClass() + " does not support UpsertAspectRequest operations");
    }

    @NotNull
    public synchronized Future<MetadataWriteResponse> emit(@NotNull MetadataChangeProposalWrapper wrapper, @Nullable Callback callback) throws IOException {
        MetadataChangeProposal proposal = FORMATTER.convert(wrapper);
        return this.emit(proposal, callback);
    }

    @NotNull
    public synchronized Future<MetadataWriteResponse> emit(@NotNull MetadataChangeProposal proposal, @Nullable Callback callback) throws IOException {
        if (callback != null) {
            throw new IllegalArgumentException(this.getClass() + " does not support emission with Callback");
        }
        String aspect = CODEC.mapToString(proposal.data());
        this.json.append(LINE).append(aspect).append(COMMA);
        return SUCCESS;
    }

    @Override
    public synchronized void close() {
        int length = this.json.length();
        if (length > OPEN.length()) {
            this.json.setLength(length - COMMA.length());
        }
        this.json.append(LINE).append(CLOSE);
    }

    public synchronized String content() {
        return this.json.toString();
    }

    static {
        CODEC.setPrettyPrinter(PRINTER);
    }
}

