/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.KeyspaceMetadata;
import com.linkedin.common.DataPlatformInstance;
import com.linkedin.common.urn.Urn;
import datahub.event.MetadataChangeProposalWrapper;
import java.net.URISyntaxException;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.KeyspaceToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class KeyspaceToDataPlatformInstanceConverter
extends KeyspaceToAspectConverter<DataPlatformInstance> {
    public KeyspaceToDataPlatformInstanceConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<DataPlatformInstance> convert(@NotNull KeyspaceMetadata keyspace) throws URISyntaxException {
        String urn = this.identifiers.urnContainer(keyspace);
        DataPlatformInstance aspect = new DataPlatformInstance().setPlatform(new Urn(this.identifiers.urnDataPlatform())).setInstance(new Urn(this.identifiers.urnDataPlatformInstance()));
        return this.wrap(urn, aspect);
    }
}

