/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.response.SchemaResponse;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.MetadataUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class KeyspaceSchemaHandler
extends AbstractHandler<Name>
implements AccessProtected {
    @Inject
    protected KeyspaceSchemaHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_SCHEMA_KEYSPACE_SCOPED.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Name keyspace) {
        this.metadata(host).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, keyspace)).onSuccess(metadata -> this.handleWithMetadata(context, keyspace, (Metadata)metadata));
    }

    private void handleWithMetadata(RoutingContext context, Name keyspace, Metadata metadata) {
        if (keyspace == null) {
            SchemaResponse schemaResponse = new SchemaResponse(metadata.exportSchemaAsString());
            context.json((Object)schemaResponse);
            return;
        }
        KeyspaceMetadata ksMetadata = MetadataUtils.keyspace(metadata, keyspace);
        if (ksMetadata == null) {
            String errorMessage = String.format("Keyspace '%s' does not exist.", keyspace);
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, errorMessage));
            return;
        }
        SchemaResponse schemaResponse = new SchemaResponse(keyspace.name(), ksMetadata.exportAsString());
        context.json((Object)schemaResponse);
    }

    private Future<Metadata> metadata(String host) {
        return this.executorPools.service().executeBlocking(() -> this.metadataFetcher.delegate(host).metadata());
    }

    @Override
    protected Name extractParamsOrThrow(RoutingContext context) {
        return this.keyspace(context, true);
    }
}

