/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.ProvidesIntoMap;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import org.apache.cassandra.sidecar.common.response.SSTableUploadResponse;
import org.apache.cassandra.sidecar.handlers.FileStreamHandler;
import org.apache.cassandra.sidecar.handlers.StreamSSTableComponentHandler;
import org.apache.cassandra.sidecar.handlers.snapshots.ClearSnapshotHandler;
import org.apache.cassandra.sidecar.handlers.snapshots.CreateSnapshotHandler;
import org.apache.cassandra.sidecar.handlers.snapshots.ListSnapshotHandler;
import org.apache.cassandra.sidecar.handlers.sstableuploads.SSTableCleanupHandler;
import org.apache.cassandra.sidecar.handlers.sstableuploads.SSTableImportHandler;
import org.apache.cassandra.sidecar.handlers.sstableuploads.SSTableUploadHandler;
import org.apache.cassandra.sidecar.handlers.validations.ValidateTableExistenceHandler;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;

@Path(value="/")
public class SSTablesAccessModule
extends AbstractModule {
    @GET
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component")
    @Operation(summary="Stream SSTable components", description="Streams SSTable component files from the Cassandra node")
    @APIResponse(description="SSTable component stream initiated successfully", responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(type=SchemaType.STRING))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.StreamSSTableComponentsRouteKey.class)
    VertxRoute streamSSTableComponentsRoute(RouteBuilder.Factory factory, StreamSSTableComponentHandler streamSSTableComponentHandler, FileStreamHandler fileStreamHandler) {
        return factory.builderForRoute().handler(streamSSTableComponentHandler).handler(fileStreamHandler).build();
    }

    @Deprecated
    @GET
    @Path(value="/api/v1/keyspace/:keyspace/table/:table/snapshots/:snapshot/component/:component")
    @Operation(summary="Stream SSTable components (deprecated)", description="Streams SSTable component files from the Cassandra node. This endpoint is deprecated.")
    @APIResponse(description="SSTable component stream initiated successfully", responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(type=SchemaType.STRING))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.DeprecatedStreamSSTableComponentsRouteKey.class)
    VertxRoute deprecatedStreamSSTableComponentsRoute(RouteBuilder.Factory factory, StreamSSTableComponentHandler streamSSTableComponentHandler, FileStreamHandler fileStreamHandler) {
        return factory.builderForRoute().handler(streamSSTableComponentHandler).handler(fileStreamHandler).build();
    }

    @GET
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:index/:component")
    @Operation(summary="Stream SSTable components with secondary index", description="Streams SSTable component files with secondary index support")
    @APIResponse(description="SSTable component with secondary index stream initiated successfully", responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(type=SchemaType.STRING))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.StreamSSTableComponentsWithSecondaryIndexRouteKey.class)
    VertxRoute streamSSTableComponentsWithSecondaryIndexRoute(RouteBuilder.Factory factory, StreamSSTableComponentHandler streamSSTableComponentHandler, FileStreamHandler fileStreamHandler) {
        return factory.builderForRoute().handler(streamSSTableComponentHandler).handler(fileStreamHandler).build();
    }

    @PUT
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot")
    @Operation(summary="Create snapshot", description="Creates a snapshot for the specified keyspace and table")
    @APIResponse(description="Snapshot created successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CreateSnapshotRouteKey.class)
    VertxRoute createSnapshotRouteKey(RouteBuilder.Factory factory, CreateSnapshotHandler createSnapshotHandler) {
        return factory.buildRouteWithHandler(createSnapshotHandler);
    }

    @GET
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot")
    @Operation(summary="List snapshot files", description="Lists all files in existing snapshots")
    @APIResponse(description="Snapshot files listed successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.ListSnapshotRouteKey.class)
    VertxRoute listSnapshotRouteKey(RouteBuilder.Factory factory, ListSnapshotHandler listSnapshotHandler) {
        return factory.buildRouteWithHandler(listSnapshotHandler);
    }

    @Deprecated
    @GET
    @Path(value="/api/v1/keyspace/:keyspace/table/:table/snapshots/:snapshot")
    @Operation(summary="List snapshots (deprecated)", description="Lists all snapshots available on the node. This endpoint is deprecated.")
    @APIResponse(description="Snapshots listed successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.DeprecatedListSnapshotRouteKey.class)
    VertxRoute deprecatedListSnapshotRouteKey(RouteBuilder.Factory factory, ListSnapshotHandler listSnapshotHandler) {
        return factory.buildRouteWithHandler(listSnapshotHandler);
    }

    @DELETE
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot")
    @Operation(summary="Clear snapshot", description="Clears/deletes an existing snapshot")
    @APIResponse(description="Snapshot cleared successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.ClearSnapshotRouteKey.class)
    VertxRoute clearSnapshotRouteKey(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, ClearSnapshotHandler clearSnapshotHandler) {
        return factory.builderForRoute().handler(validateTableExistence).handler(clearSnapshotHandler).build();
    }

    @PUT
    @Path(value="/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component")
    @Operation(summary="Upload SSTable", description="Uploads SSTable files to the Cassandra node for staging")
    @APIResponse(description="SSTable uploaded successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=SSTableUploadResponse.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.SSTableUploadRouteKey.class)
    VertxRoute sstableUploadRoute(RouteBuilder.Factory factory, SSTableUploadHandler sstableUploadHandler) {
        return factory.buildRouteWithHandler(sstableUploadHandler);
    }

    @PUT
    @Path(value="/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/import")
    @Operation(summary="Import SSTable", description="Imports previously uploaded SSTable files into the Cassandra node")
    @APIResponse(description="SSTable imported successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.SSTableImportRouteKey.class)
    VertxRoute sstableImportRoute(RouteBuilder.Factory factory, SSTableImportHandler sstableImportHandler) {
        return factory.buildRouteWithHandler(sstableImportHandler);
    }

    @DELETE
    @Path(value="/api/v1/uploads/:uploadId")
    @Operation(summary="Clean up SSTable files", description="Cleans up SSTable files to free up disk space")
    @APIResponse(description="SSTable cleanup completed successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.SSTableCleanupRouteKey.class)
    VertxRoute sstableCleanupRoute(RouteBuilder.Factory factory, SSTableCleanupHandler sstableCleanupHandler) {
        return factory.buildRouteWithHandler(sstableCleanupHandler);
    }
}

