/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.google.common.util.concurrent.SidecarRateLimiter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.netty.handler.ssl.OpenSsl;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.restore.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@Singleton
public class StorageClientPool
implements SdkAutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageClientPool.class);
    private final Map<String, StorageClient> clientPool = new ConcurrentHashMap<String, StorageClient>();
    private final Map<UUID, StorageClient> clientByJobId = new ConcurrentHashMap<UUID, StorageClient>();
    private final ThreadPoolExecutor sharedExecutor;
    private final S3ClientConfiguration clientConfig;
    private final SidecarRateLimiter ingressFileRateLimiter;

    @Inject
    public StorageClientPool(SidecarConfiguration configuration, @Named(value="IngressFileRateLimiter") SidecarRateLimiter ingressFileRateLimiter) {
        this.clientConfig = configuration.s3ClientConfiguration();
        this.ingressFileRateLimiter = ingressFileRateLimiter;
        this.sharedExecutor = new ThreadPoolExecutor(this.clientConfig.concurrency(), this.clientConfig.concurrency(), this.clientConfig.threadKeepAlive().quantity(), this.clientConfig.threadKeepAlive().unit(), new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().threadNamePrefix(this.clientConfig.threadNamePrefix()).daemonThreads(Boolean.valueOf(true)).build());
        this.sharedExecutor.allowCoreThreadTimeOut(true);
    }

    public StorageClient storageClient(RestoreJob restoreJob) throws RestoreJobFatalException {
        String region = restoreJob.secrets.readCredentials().region();
        StorageClient client = this.clientByJobId.computeIfAbsent(restoreJob.jobId, id -> this.storageClient(region));
        return client.authenticate(restoreJob);
    }

    public void revokeCredentials(UUID jobId) {
        this.clientByJobId.computeIfPresent(jobId, (id, client) -> {
            client.revokeCredentials((UUID)id);
            return null;
        });
    }

    private StorageClient storageClient(String region) {
        return this.clientPool.computeIfAbsent(region, k -> {
            this.logIfOpenSslUnavailable();
            Map<SdkAdvancedAsyncClientOption, ThreadPoolExecutor> advancedOptions = Collections.singletonMap(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.sharedExecutor);
            Duration apiCallTimeout = Duration.ofMillis(this.clientConfig.apiCallTimeout().toMillis());
            S3AsyncClientBuilder clientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().region(Region.of((String)region))).overrideConfiguration(b -> b.apiCallAttemptTimeout(apiCallTimeout).apiCallTimeout(apiCallTimeout))).asyncConfiguration(b -> b.advancedOptions(advancedOptions));
            S3ProxyConfiguration s3ProxyConfiguration = this.clientConfig.proxyConfig();
            URI endpointOverride = s3ProxyConfiguration.endpointOverride();
            if (endpointOverride != null) {
                ((S3AsyncClientBuilder)clientBuilder.endpointOverride(endpointOverride)).forcePathStyle(Boolean.valueOf(true));
            }
            NettyNioAsyncHttpClient.Builder nettyClientBuilder = NettyNioAsyncHttpClient.builder();
            S3ProxyConfiguration config = this.clientConfig.proxyConfig();
            if (config.isPresent()) {
                ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().host(config.proxy().getHost()).port(config.proxy().getPort()).scheme(config.proxy().getScheme()).username(config.username()).password(config.password()).build();
                nettyClientBuilder.proxyConfiguration(proxyConfig);
            }
            clientBuilder.httpClientBuilder((SdkAsyncHttpClient.Builder)nettyClientBuilder);
            return new StorageClient((S3AsyncClient)clientBuilder.build(), this.clientConfig.rangeGetObjectBytesSize(), this.ingressFileRateLimiter);
        });
    }

    public void close() {
        this.clientPool.values().forEach(StorageClient::close);
        this.clientPool.clear();
        this.clientByJobId.clear();
    }

    private void logIfOpenSslUnavailable() {
        if (!OpenSsl.isAvailable()) {
            LOGGER.info("OpenSSL is not available for S3AsyncClient");
        }
    }
}

