/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.acl.AdminIdentityResolver;
import org.apache.cassandra.sidecar.acl.authorization.AuthorizationParameterValidateHandler;
import org.apache.cassandra.sidecar.acl.authorization.AuthorizationWithAdminBypassHandler;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.routes.SettableVertxRoute;
import org.apache.cassandra.sidecar.routes.VertxRoute;

public class RouteBuilder {
    private final AccessControlConfiguration accessControlConfiguration;
    private final AuthorizationProvider authorizationProvider;
    private final AdminIdentityResolver adminIdentityResolver;
    private final AuthorizationParameterValidateHandler authZParameterValidateHandler;
    private boolean setBodyHandler;
    private boolean accessProtected = true;
    private final List<Handler<RoutingContext>> handlers = new ArrayList<Handler<RoutingContext>>();

    private RouteBuilder(AccessControlConfiguration accessControlConfiguration, AuthorizationProvider authorizationProvider, AdminIdentityResolver adminIdentityResolver, AuthorizationParameterValidateHandler authZParameterValidateHandler) {
        this.accessControlConfiguration = accessControlConfiguration;
        this.authorizationProvider = authorizationProvider;
        this.adminIdentityResolver = adminIdentityResolver;
        this.authZParameterValidateHandler = authZParameterValidateHandler;
    }

    public RouteBuilder setBodyHandler(Boolean setBodyHandler) {
        this.setBodyHandler = setBodyHandler;
        return this;
    }

    public RouteBuilder handler(Handler<RoutingContext> handler) {
        this.handlers.add(handler);
        return this;
    }

    RouteBuilder setUnauthorized() {
        this.accessProtected = false;
        return this;
    }

    public SettableVertxRoute build() {
        return new SettableVertxRoute(){

            @Override
            public void mountTo(Router router) {
                HttpMethod method = this.httpMethod();
                String endpoint = this.routeURI();
                Objects.requireNonNull(method, "Http method must be set");
                Preconditions.checkArgument((endpoint != null && !endpoint.isEmpty() ? 1 : 0) != 0, (String)"Endpoint must be set");
                Preconditions.checkArgument((!RouteBuilder.this.handlers.isEmpty() ? 1 : 0) != 0, (String)"Handler chain can not be empty");
                Route route = router.route(method, endpoint);
                if (RouteBuilder.this.setBodyHandler) {
                    route.handler((Handler)BodyHandler.create());
                }
                if (RouteBuilder.this.accessControlConfiguration.enabled()) {
                    AuthorizationWithAdminBypassHandler authorizationHandler = new AuthorizationWithAdminBypassHandler(RouteBuilder.this.authZParameterValidateHandler, RouteBuilder.this.adminIdentityResolver, RouteBuilder.this.requiredAuthorization());
                    authorizationHandler.addAuthorizationProvider(RouteBuilder.this.authorizationProvider);
                    authorizationHandler.variableConsumer(RouteBuilder.this.routeGenericVariableConsumer());
                    route.handler((Handler)authorizationHandler);
                }
                RouteBuilder.this.handlers.forEach(arg_0 -> ((Route)route).handler(arg_0));
            }
        };
    }

    private Authorization requiredAuthorization() {
        Set<Authorization> requiredAuthorizations = this.handlers.stream().filter(handler -> handler instanceof AccessProtected).map(handler -> (AccessProtected)handler).flatMap(handler -> handler.requiredAuthorizations().stream()).collect(Collectors.toSet());
        if (this.accessProtected && requiredAuthorizations.isEmpty()) {
            throw new ConfigurationException("Authorized route must have required authorizations declared");
        }
        if (!this.accessProtected && !requiredAuthorizations.isEmpty()) {
            throw new ConfigurationException("Unauthorized route must not have required authorizations declared");
        }
        AndAuthorization andAuthorization = AndAuthorization.create();
        requiredAuthorizations.forEach(arg_0 -> ((AndAuthorization)andAuthorization).addAuthorization(arg_0));
        return andAuthorization;
    }

    private BiConsumer<RoutingContext, AuthorizationContext> routeGenericVariableConsumer() {
        return (routingCtx, authZContext) -> {
            Optional<QualifiedTableName> optional = RoutingContextUtils.getAsOptional(routingCtx, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME);
            String keyspace = null;
            String table = null;
            if (optional.isPresent()) {
                QualifiedTableName qualifiedTableName = optional.get();
                keyspace = qualifiedTableName.keyspace();
                table = qualifiedTableName.tableName();
            }
            if (keyspace != null) {
                authZContext.variables().add("keyspace", keyspace);
            }
            if (table != null) {
                authZContext.variables().add("table", table);
            }
        };
    }

    public static class Factory {
        private final AccessControlConfiguration accessControlConfiguration;
        private final AuthorizationProvider authorizationProvider;
        private final AdminIdentityResolver adminIdentityResolver;
        private final AuthorizationParameterValidateHandler authZParameterValidateHandler;

        public Factory(AccessControlConfiguration accessControlConfiguration, AuthorizationProvider authorizationProvider, AdminIdentityResolver adminIdentityResolver, AuthorizationParameterValidateHandler authZParameterValidateHandler) {
            this.accessControlConfiguration = accessControlConfiguration;
            this.authorizationProvider = authorizationProvider;
            this.adminIdentityResolver = adminIdentityResolver;
            this.authZParameterValidateHandler = authZParameterValidateHandler;
        }

        public RouteBuilder builderForRoute() {
            return new RouteBuilder(this.accessControlConfiguration, this.authorizationProvider, this.adminIdentityResolver, this.authZParameterValidateHandler);
        }

        public VertxRoute buildRouteWithHandler(Handler<RoutingContext> handler) {
            return this.builderForRoute().handler(handler).build();
        }

        public RouteBuilder builderForUnauthorizedRoute() {
            return this.builderForRoute().setUnauthorized();
        }
    }
}

