/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOBBatchQueryWrapper {
    protected BatchQuery query;
    protected List<DbAttribute> dbAttributes;
    protected boolean[] qualifierAttributes;
    protected boolean[] allLOBAttributes;
    protected Object[] updatedLOBAttributes;
    protected boolean hasNext;

    public LOBBatchQueryWrapper(BatchQuery query) {
        this.query = query;
        this.dbAttributes = query.getDbAttributes();
        int len = this.dbAttributes.size();
        this.qualifierAttributes = new boolean[len];
        this.allLOBAttributes = new boolean[len];
        this.updatedLOBAttributes = new Object[len];
        this.indexQualifierAttributes();
    }

    public boolean next() {
        this.hasNext = this.query.next();
        if (this.hasNext) {
            this.indexLOBAttributes();
        }
        return this.hasNext;
    }

    protected void indexQualifierAttributes() {
        int len = this.dbAttributes.size();
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = this.dbAttributes.get(i);
            int type = attribute.getType();
            this.qualifierAttributes[i] = attribute.isPrimaryKey();
            this.allLOBAttributes[i] = type == 2004 || type == 2005;
        }
    }

    protected void indexLOBAttributes() {
        int len = this.updatedLOBAttributes.length;
        for (int i = 0; i < len; ++i) {
            Object value;
            this.updatedLOBAttributes[i] = null;
            if (!this.allLOBAttributes[i] || (value = this.query.getValue(i)) == null) continue;
            this.updatedLOBAttributes[i] = this.dbAttributes.get(i).getType() == 2004 ? (Object)this.convertToBlobValue(value) : this.convertToClobValue(value);
        }
    }

    protected byte[] convertToBlobValue(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.length == 0 ? null : bytes;
        }
        if (value instanceof Serializable) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            try {
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(value);
                out.close();
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Error serializing object", (Throwable)e, new Object[0]);
            }
            return bytes.toByteArray();
        }
        return null;
    }

    protected Object convertToClobValue(Object value) {
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return chars.length == 0 ? null : chars;
        }
        String strValue = value.toString();
        return strValue.length() == 0 ? null : strValue;
    }

    public List<DbAttribute> getDbAttributesForLOBSelectQualifier() {
        int len = this.qualifierAttributes.length;
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(len);
        for (int i = 0; i < len; ++i) {
            if (!this.qualifierAttributes[i]) continue;
            attributes.add(this.dbAttributes.get(i));
        }
        return attributes;
    }

    public List<DbAttribute> getDbAttributesForUpdatedLOBColumns() {
        if (!this.hasNext) {
            throw new IllegalStateException("No more rows in the BatchQuery.");
        }
        int len = this.updatedLOBAttributes.length;
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(len);
        for (int i = 0; i < len; ++i) {
            if (this.updatedLOBAttributes[i] == null) continue;
            attributes.add(this.dbAttributes.get(i));
        }
        return attributes;
    }

    public List getValuesForLOBSelectQualifier() {
        if (!this.hasNext) {
            throw new IllegalStateException("No more rows in the BatchQuery.");
        }
        int len = this.qualifierAttributes.length;
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            if (!this.qualifierAttributes[i]) continue;
            values.add(this.query.getValue(i));
        }
        return values;
    }

    public List getValuesForUpdatedLOBColumns() {
        if (!this.hasNext) {
            throw new IllegalStateException("No more rows in the BatchQuery.");
        }
        int len = this.updatedLOBAttributes.length;
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            if (this.updatedLOBAttributes[i] == null) continue;
            values.add(this.updatedLOBAttributes[i]);
        }
        return values;
    }

    public BatchQuery getQuery() {
        return this.query;
    }
}

