/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesView;
import org.apache.cayenne.util.Util;

public class SchemaUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "Set/update schema for all DbEntities";
    public static final String UNINIT_CONTROL = "Do not override existing non-empty schema";
    protected DefaultsPreferencesView view;

    public SchemaUpdateController(ProjectController mediator, DataMap dataMap) {
        super(mediator, dataMap);
    }

    public void startupAction() {
        this.view = new DefaultsPreferencesView(ALL_CONTROL, UNINIT_CONTROL);
        this.view.setTitle("Update DbEntities Schema");
        this.initController();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaUpdateController.this.updateSchema();
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaUpdateController.this.view.dispose();
            }
        });
    }

    protected void updateSchema() {
        boolean doAll = this.isAllEntities();
        String defaultSchema = this.dataMap.getDefaultSchema();
        for (DbEntity entity : this.dataMap.getDbEntities()) {
            if (!doAll && !Util.isEmptyString(entity.getSchema()) || Util.nullSafeEquals(defaultSchema, entity.getSchema())) continue;
            entity.setSchema(defaultSchema);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, entity));
        }
        for (Procedure procedure : this.dataMap.getProcedures()) {
            if (!doAll && !Util.isEmptyString(procedure.getSchema()) || Util.nullSafeEquals(defaultSchema, procedure.getSchema())) continue;
            procedure.setSchema(defaultSchema);
            this.mediator.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
        this.view.dispose();
    }
}

