/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.query;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.query.QueryTypeView;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateQueryUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneController;

public class QueryType
extends CayenneController {
    protected ProjectController mediator;
    protected DataMap dataMap;
    protected DataChannelDescriptor domain;
    protected QueryTypeView view = new QueryTypeView();
    protected String type;

    public QueryType(ProjectController mediator, DataMap root) {
        super(mediator);
        this.initController();
        this.type = "SelectQuery";
        this.mediator = mediator;
        this.dataMap = mediator.getCurrentDataMap();
        this.domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.view.dispose();
            }
        });
        this.view.getSaveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.createQuery();
            }
        });
        this.view.getObjectSelect().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.setObjectSelectQuery();
            }
        });
        this.view.getSqlSelect().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.setRawSQLQuery();
            }
        });
        this.view.getProcedureSelect().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.setProcedureQuery();
            }
        });
        this.view.getEjbqlSelect().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryType.this.setEjbqlQuery();
            }
        });
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public void createQuery() {
        String queryType = this.getSelectedQuery();
        QueryDescriptor query = QueryDescriptor.descriptor(queryType);
        query.setName(NameBuilder.builder(query, this.dataMap).name());
        query.setDataMap(this.dataMap);
        this.dataMap.addQueryDescriptor(query);
        this.mediator.getApplication().getUndoManager().addEdit(new CreateQueryUndoableEdit(this.domain, this.dataMap, query));
        QueryType.fireQueryEvent(this, this.mediator, this.dataMap, query);
        this.view.dispose();
    }

    public static void fireQueryEvent(Object src, ProjectController mediator, DataMap dataMap, QueryDescriptor query) {
        mediator.fireQueryEvent(new QueryEvent(src, query, 2, dataMap));
        mediator.fireQueryDisplayEvent(new QueryDisplayEvent(src, query, dataMap, (DataChannelDescriptor)mediator.getProject().getRootNode()));
    }

    public String getSelectedQuery() {
        return this.type;
    }

    public void setObjectSelectQuery() {
        this.type = "SelectQuery";
    }

    public void setRawSQLQuery() {
        this.type = "SQLTemplate";
    }

    public void setProcedureQuery() {
        this.type = "ProcedureQuery";
    }

    public void setEjbqlQuery() {
        this.type = "EJBQLQuery";
    }
}

