/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.commitlog.CommitLogFilter;
import org.apache.cayenne.commitlog.CommitLogListener;
import org.apache.cayenne.commitlog.CommitLogModule;
import org.apache.cayenne.commitlog.meta.AnnotationCommitLogEntityFactory;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.commitlog.meta.IncludeAllCommitLogEntityFactory;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.tx.TransactionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogModuleExtender {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogModuleExtender.class);
    private Class<? extends CommitLogEntityFactory> entityFactoryType;
    private Collection<Class<? extends CommitLogListener>> listenerTypes;
    private Collection<CommitLogListener> listenerInstances;
    private boolean excludeFromTransaction;

    CommitLogModuleExtender() {
        this.entityFactory(IncludeAllCommitLogEntityFactory.class);
        this.listenerTypes = new HashSet<Class<? extends CommitLogListener>>();
        this.listenerInstances = new HashSet<CommitLogListener>();
    }

    public CommitLogModuleExtender addListener(Class<? extends CommitLogListener> type) {
        this.listenerTypes.add(type);
        return this;
    }

    public CommitLogModuleExtender addListener(CommitLogListener instance) {
        this.listenerInstances.add(instance);
        return this;
    }

    public CommitLogModuleExtender excludeFromTransaction() {
        this.excludeFromTransaction = true;
        return this;
    }

    public CommitLogModuleExtender commitLogAnnotationEntitiesOnly() {
        return this.entityFactory(AnnotationCommitLogEntityFactory.class);
    }

    public CommitLogModuleExtender entityFactory(Class<? extends CommitLogEntityFactory> entityFactoryType) {
        this.entityFactoryType = entityFactoryType;
        return this;
    }

    public Module module() {
        return new Module(){

            public void configure(Binder binder) {
                if (CommitLogModuleExtender.this.listenerTypes.isEmpty() && CommitLogModuleExtender.this.listenerInstances.isEmpty()) {
                    LOGGER.info("No listeners configured. Skipping CommitLogFilter registration");
                    return;
                }
                binder.bind(CommitLogEntityFactory.class).to(CommitLogModuleExtender.this.entityFactoryType);
                ListBuilder listeners = CommitLogModule.contributeListeners(binder).addAll(CommitLogModuleExtender.this.listenerInstances);
                for (Class type : CommitLogModuleExtender.this.listenerTypes) {
                    binder.bind(type).to(type);
                    listeners.add(type);
                }
                if (CommitLogModuleExtender.this.excludeFromTransaction) {
                    ServerModule.contributeDomainFilters((Binder)binder).addAfter(CommitLogFilter.class, TransactionFilter.class);
                } else {
                    ServerModule.contributeDomainFilters((Binder)binder).insertBefore(CommitLogFilter.class, TransactionFilter.class);
                }
            }
        };
    }
}

