/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.path;

import java.io.File;
import org.apache.cayenne.modeler.util.path.PathTrimmer;

public class LongPathTrimmer
implements PathTrimmer {
    private static final String PATH_SEPARATOR = File.separator;
    private static final int PATH_LENGTH_THRESHOLD = 8;

    private String[] splitPath(String path) {
        return path.split(PATH_SEPARATOR);
    }

    private String joinPath(String[] components) {
        if (components.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(components[0]);
        for (int i = 1; i < components.length; ++i) {
            sb.append(PATH_SEPARATOR);
            sb.append(components[i]);
        }
        return sb.toString();
    }

    @Override
    public String trim(String path) {
        String[] components = this.splitPath(path);
        if (components.length <= 9) {
            return path;
        }
        String[] strippedComponents = new String[9];
        int half = 4;
        int end2 = components.length - half;
        int idx = 0;
        boolean trimAdded = false;
        for (int i = 0; i < components.length; ++i) {
            if (i < half || i >= end2) {
                strippedComponents[idx++] = components[i];
                continue;
            }
            if (trimAdded) continue;
            strippedComponents[idx++] = "...";
            trimAdded = true;
        }
        return this.joinPath(strippedComponents);
    }
}

