/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.util.CayenneMapEntry;

public class ASTDbPath
extends ASTPath {
    private static final long serialVersionUID = 6623715674339310782L;
    public static final String DB_PREFIX = "db:";

    ASTDbPath(int id) {
        super(id);
    }

    public ASTDbPath() {
        super(56);
    }

    public ASTDbPath(Object value) {
        super(56);
        this.setPath(value);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        if (o instanceof Entity) {
            return this.evaluateEntityNode((Entity)o);
        }
        Map<?, ?> map = this.toMap(o);
        int finalDotIndex = this.path.lastIndexOf(46);
        String finalPathComponent = finalDotIndex == -1 ? this.path : this.path.substring(finalDotIndex + 1);
        return map != null ? map.get(finalPathComponent) : null;
    }

    protected Map<?, ?> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        if (o instanceof ObjectId) {
            return ((ObjectId)o).getIdSnapshot();
        }
        if (o instanceof Persistent) {
            Persistent persistent = (Persistent)o;
            return persistent.getObjectContext() != null ? this.toMap_AttachedObject(persistent.getObjectContext(), persistent) : this.toMap_DetachedObject(persistent);
        }
        return null;
    }

    private Map<?, ?> toMap_AttachedObject(ObjectContext context, Persistent persistent) {
        return this.path.indexOf(46) >= 0 ? this.toMap_AttchedObject_MultiStepPath(context, persistent) : this.toMap_AttchedObject_SingleStepPath(context, persistent);
    }

    private Map<?, ?> toMap_AttchedObject_MultiStepPath(ObjectContext context, Persistent persistent) {
        CayenneMapEntry component;
        Iterator<CayenneMapEntry> pathComponents = Cayenne.getObjEntity(persistent).getDbEntity().resolvePathComponents(this);
        LinkedList<DbRelationship> reversedPathComponents = new LinkedList<DbRelationship>();
        while (pathComponents.hasNext() && (component = pathComponents.next()) instanceof DbRelationship) {
            DbRelationship rel = (DbRelationship)component;
            DbRelationship reverseRelationship = rel.getReverseRelationship();
            if (reverseRelationship == null) {
                reverseRelationship = rel.createReverseRelationship();
            }
            reversedPathComponents.addFirst(reverseRelationship);
        }
        DbEntity finalEntity = ((DbRelationship)reversedPathComponents.get(0)).getSourceEntity();
        StringBuilder reversedPathStr = new StringBuilder();
        for (int i = 0; i < reversedPathComponents.size(); ++i) {
            reversedPathStr.append(((DbRelationship)reversedPathComponents.get(i)).getName());
            if (i >= reversedPathComponents.size() - 1) continue;
            reversedPathStr.append('.');
        }
        return (Map)ObjectSelect.dbQuery(finalEntity.getName()).where(ExpressionFactory.matchDbExp(reversedPathStr.toString(), persistent)).selectOne(context);
    }

    private Map<?, ?> toMap_AttchedObject_SingleStepPath(ObjectContext context, Persistent persistent) {
        ObjectId oid = persistent.getObjectId();
        if (context instanceof DataContext) {
            return ((DataContext)context).currentSnapshot(persistent);
        }
        if (oid != null) {
            return SelectById.dataRowQuery(persistent.getObjectId()).selectOne(context);
        }
        return this.toMap_DetachedObject(persistent);
    }

    private Map<?, ?> toMap_DetachedObject(Persistent persistent) {
        ObjectId oid = persistent.getObjectId();
        return oid != null ? oid.getIdSnapshot() : null;
    }

    @Override
    public Expression shallowCopy() {
        ASTDbPath copy = new ASTDbPath(this.id);
        copy.path = this.path;
        return copy;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append(DB_PREFIX);
        out.append(rootId);
        out.append('.');
        out.append(this.path);
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append(DB_PREFIX).append(this.path);
    }

    @Override
    public int getType() {
        return 27;
    }
}

