/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannelSyncCallbackAction;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.tx.TransactionManager;

public class TransactionFilter
implements DataChannelSyncFilter {
    @Inject
    protected TransactionManager transactionManager;

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelSyncFilterChain filterChain) {
        GraphDiff result;
        DataChannelSyncCallbackAction callbackAction = DataChannelSyncCallbackAction.getCallbackAction(originatingContext.getChannel().getEntityResolver().getCallbackRegistry(), originatingContext.getGraphManager(), changes, syncType);
        callbackAction.applyPreCommit();
        switch (syncType) {
            case 3: {
                result = filterChain.onSync(originatingContext, changes, syncType);
                break;
            }
            case 1: 
            case 2: {
                result = this.transactionManager.performInTransaction(() -> filterChain.onSync(originatingContext, changes, syncType));
                break;
            }
            default: {
                throw new CayenneRuntimeException("Invalid synchronization type: %d", syncType);
            }
        }
        callbackAction.applyPostCommit();
        return result;
    }
}

