/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeHandler_V11
implements UpgradeHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeHandler_V11.class);
    private static final List<String> defaultTemplatePaths = Arrays.asList("templates/v4_1/singleclass.vm", "templates/v4_1/superclass.vm", "templates/v4_1/subclass.vm", "templates/v4_1/embeddable-singleclass.vm", "templates/v4_1/embeddable-superclass.vm", "templates/v4_1/embeddable-subclass.vm", "templates/v4_1/datamap-singleclass.vm", "templates/v4_1/datamap-superclass.vm", "templates/v4_1/datamap-subclass.vm");

    @Override
    public String getVersion() {
        return "11";
    }

    @Override
    public void processProjectDom(UpgradeUnit upgradeUnit) {
        this.updateDomainSchemaAndVersion(upgradeUnit);
        this.updateDataNodeConnectionPool(upgradeUnit);
    }

    @Override
    public void processDataMapDom(UpgradeUnit upgradeUnit) {
        this.updateDataMapSchemaAndVersion(upgradeUnit);
        this.updateExtensionSchema(upgradeUnit, "cgen");
        this.updateExtensionSchema(upgradeUnit, "dbImport");
        this.updateExtensionSchema(upgradeUnit, "graph");
        this.upgradeComments(upgradeUnit);
        this.dropROPProperties(upgradeUnit);
        this.dropObjEntityClientInfo(upgradeUnit);
        this.upgradeGenericObjEntity(upgradeUnit);
        this.updateCgenConfig(upgradeUnit);
        this.updateDbImportConfig(upgradeUnit);
    }

    private void upgradeComments(UpgradeUnit upgradeUnit) {
        NodeList infoNodes;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            infoNodes = (NodeList)xpath.evaluate("//*[local-name()='property']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int j = 0; j < infoNodes.getLength(); ++j) {
            Element infoElement = (Element)infoNodes.item(j);
            if (!infoElement.hasAttribute("xmlns:info")) continue;
            infoElement.setAttribute("xmlns:info", "http://cayenne.apache.org/schema/11/info");
        }
    }

    private void dropROPProperties(UpgradeUnit upgradeUnit) {
        NodeList propertyNodes;
        Element dataMap = upgradeUnit.getDocument().getDocumentElement();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            propertyNodes = (NodeList)xpath.evaluate("/data-map/property", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception ex) {
            return;
        }
        for (int j = 0; j < propertyNodes.getLength(); ++j) {
            String name;
            Element propertyElement = (Element)propertyNodes.item(j);
            switch (name = propertyElement.getAttribute("name")) {
                case "clientSupported": 
                case "defaultClientPackage": 
                case "defaultClientSuperclass": {
                    dataMap.removeChild(propertyElement);
                }
            }
        }
    }

    private void dropObjEntityClientInfo(UpgradeUnit upgradeUnit) {
        NodeList objEntityNodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            objEntityNodes = (NodeList)xpath.evaluate("/data-map/obj-entity", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception ex) {
            return;
        }
        for (int j = 0; j < objEntityNodes.getLength(); ++j) {
            Element objEntityElement = (Element)objEntityNodes.item(j);
            objEntityElement.removeAttribute("serverOnly");
            objEntityElement.removeAttribute("clientClassName");
            objEntityElement.removeAttribute("clientSuperClassName");
        }
    }

    private void upgradeGenericObjEntity(UpgradeUnit upgradeUnit) {
        NodeList objEntityNodes;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            objEntityNodes = (NodeList)xpath.evaluate("/data-map/obj-entity", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception ex) {
            return;
        }
        for (int j = 0; j < objEntityNodes.getLength(); ++j) {
            Element objEntityElement = (Element)objEntityNodes.item(j);
            String className = objEntityElement.getAttribute("className");
            if (!"org.apache.cayenne.CayenneDataObject".equals(className)) continue;
            objEntityElement.setAttribute("className", "org.apache.cayenne.GenericPersistentObject");
        }
    }

    private void updateDbImportConfig(UpgradeUnit upgradeUnit) {
        NodeList nodes;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            nodes = (NodeList)xpath.evaluate("/data-map/*[local-name()='dbImport']/*[local-name()='usePrimitives']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            return;
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element element = (Element)nodes.item(j);
            element.getParentNode().removeChild(element);
        }
    }

    private void updateCgenConfig(UpgradeUnit upgradeUnit) {
        this.renameQueryTemplates(upgradeUnit);
        this.dropCgenClientConfig(upgradeUnit);
        this.updateTemplates(upgradeUnit);
    }

    private void updateDataNodeConnectionPool(UpgradeUnit upgradeUnit) {
        NodeList nodes;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            nodes = (NodeList)xpath.evaluate("/domain/node", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            return;
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element propertyElement = (Element)nodes.item(j);
            String factory = propertyElement.getAttribute("factory");
            if (!"org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory".equals(factory)) continue;
            propertyElement.setAttribute("factory", "org.apache.cayenne.configuration.runtime.XMLPoolingDataSourceFactory");
        }
    }

    private void renameQueryTemplates(UpgradeUnit upgradeUnit) {
        Node element;
        int j;
        NodeList querySuperTemplates;
        NodeList queryTemplates;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            queryTemplates = (NodeList)xpath.evaluate("/data-map/*[local-name()='cgen']/*[local-name()='queryTemplate']", upgradeUnit.getDocument(), XPathConstants.NODESET);
            querySuperTemplates = (NodeList)xpath.evaluate("/data-map/*[local-name()='cgen']/*[local-name()='querySuperTemplate']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            return;
        }
        for (j = 0; j < queryTemplates.getLength(); ++j) {
            element = queryTemplates.item(j);
            upgradeUnit.getDocument().renameNode(element, null, "dataMapTemplate");
        }
        for (j = 0; j < querySuperTemplates.getLength(); ++j) {
            element = querySuperTemplates.item(j);
            upgradeUnit.getDocument().renameNode(element, null, "dataMapSuperTemplate");
        }
    }

    private void dropCgenClientConfig(UpgradeUnit upgradeUnit) {
        NodeList nodes;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            nodes = (NodeList)xpath.evaluate("/data-map/*[local-name()='cgen']/*[local-name()='client']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            return;
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element element = (Element)nodes.item(j);
            element.getParentNode().removeChild(element);
        }
    }

    private void updateTemplates(UpgradeUnit upgradeUnit) {
        this.updateTemplate(upgradeUnit, "template");
        this.updateTemplate(upgradeUnit, "superTemplate");
        this.updateTemplate(upgradeUnit, "embeddableTemplate");
        this.updateTemplate(upgradeUnit, "embeddableSuperTemplate");
        this.updateTemplate(upgradeUnit, "dataMapTemplate");
        this.updateTemplate(upgradeUnit, "dataMapSuperTemplate");
    }

    private void updateTemplate(UpgradeUnit upgradeUnit, String nodeName) {
        NodeList templates;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            templates = (NodeList)xpath.evaluate("/data-map/*[local-name()='cgen']/*[local-name()='" + nodeName + "']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            return;
        }
        for (int j = 0; j < templates.getLength(); ++j) {
            Node node = templates.item(j).getFirstChild();
            if (node == null) continue;
            String dataMapPath = upgradeUnit.getResource().getURL().getPath();
            node.setNodeValue(this.readTemplateFile(node.getNodeValue(), dataMapPath));
        }
    }

    private String readTemplateFile(String path, String dataMapPath) {
        if (!this.isTemplateDefault(path)) {
            try {
                String templateFromClassPath = this.readTemplateFromClassPath(path);
                if (templateFromClassPath != null) {
                    return templateFromClassPath;
                }
                return this.readTemplateFromFile(path, dataMapPath);
            }
            catch (NoSuchFileException e) {
                return "The template " + path + " was not found during the project upgrade. Use the template editor in Cayenne modeler to set the template";
            }
            catch (IOException e) {
                logger.warn("Can't read the file: " + path, e);
                return "Can't read the file: " + path + e.getMessage();
            }
        }
        return path;
    }

    private String readTemplateFromClassPath(String path) throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (stream != null) {
                String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
        }
        return null;
    }

    private String readTemplateFromFile(String path, String dataMapPath) throws IOException {
        String absolutPath = this.buildPath(path, dataMapPath);
        return new String(Files.readAllBytes(Paths.get(absolutPath, new String[0])));
    }

    private String buildPath(String path, String dataMapPath) throws IOException {
        File dataMap = new File(dataMapPath);
        return new File(dataMap.getParent(), path).getCanonicalPath();
    }

    private boolean isTemplateDefault(String template) {
        return defaultTemplatePaths.contains(template);
    }
}

