/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.convert;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.access.DataAccessor;

public class PropertiesConverter {
    private Properties graphData = new Properties();
    private DataAccessor vertexAccessor = new DataAccessor();

    public Properties getGraphData() {
        return (Properties)this.graphData.clone();
    }

    public void reset() {
        this.graphData.clear();
    }

    public void build(Digraph digraph) {
        for (Map.Entry<Object, Object> entry : this.graphData.entrySet()) {
            Object origin = this.vertexAccessor.create(entry.getKey());
            digraph.addVertex(origin);
            StringTokenizer st = new StringTokenizer((String)entry.getValue(), ";");
            while (st.hasMoreTokens()) {
                digraph.putArc(origin, this.vertexAccessor.create(st.nextToken()), Boolean.TRUE);
            }
        }
    }

    public void convert(Digraph digraph) {
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object origin = i.next();
            String key = this.vertexAccessor.getId(origin).toString();
            StringBuffer value = new StringBuffer();
            boolean firstDst = true;
            ArcIterator j = digraph.outgoingIterator(origin);
            while (j.hasNext()) {
                j.next();
                if (firstDst) {
                    value.append(this.vertexAccessor.getId(j.getDestination()));
                    firstDst = false;
                    continue;
                }
                value.append(';').append(j.getDestination());
            }
            this.graphData.setProperty(key, value.toString());
        }
    }

    public void setVertexAccessor(DataAccessor vertexAccessor) {
        this.vertexAccessor = vertexAccessor;
    }

    public DataAccessor getVertexAccessor() {
        return this.vertexAccessor;
    }
}

