/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.CollectionFactory;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.FilterIteration;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.ReversedIteration;

public class StrongConnection
extends Algorithm {
    private DigraphIteration digraph;
    private DigraphIteration reverseDigraph;
    private DigraphIteration filteredDigraph;
    private DepthFirstStampSearch directDfs;
    private DepthFirstSearch reverseDfs;
    private Set seen = new HashSet();
    private Iterator vertexIterator;
    private ArrayStack dfsStack = new ArrayStack();
    private DFSSeenVerticesPredicate reverseDFSFilter = new DFSSeenVerticesPredicate();
    private CollectionFactory componentFactory;

    public StrongConnection(DigraphIteration digraph, CollectionFactory componentFactory) {
        this.digraph = digraph;
        this.componentFactory = componentFactory;
        this.filteredDigraph = new FilterIteration(digraph, new NotSeenPredicate(), GraphUtils.TRUE_PREDICATE);
        this.reverseDigraph = new FilterIteration(new ReversedIteration(digraph), this.reverseDFSFilter, GraphUtils.TRUE_PREDICATE);
        this.vertexIterator = this.filteredDigraph.vertexIterator();
        this.runDirectDFS();
    }

    public boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    public Object next() {
        Collection component = this.buildStronglyConnectedComponent();
        if (this.dfsStack.isEmpty()) {
            this.runDirectDFS();
        }
        return component;
    }

    public Digraph contract(Digraph contractedDigraph) {
        return this.contract(contractedDigraph, null);
    }

    public Digraph contract(Digraph contractedDigraph, CollectionFactory arcFactory) {
        ArrayList components = new ArrayList();
        CollectionUtils.addAll(components, (Iterator)this);
        HashMap memberToComponent = new HashMap();
        for (Collection c : components) {
            Iterator j = c.iterator();
            while (j.hasNext()) {
                memberToComponent.put(j.next(), c);
            }
        }
        for (Collection origin : components) {
            contractedDigraph.addVertex(origin);
            for (Object member : origin) {
                ArcIterator k = this.digraph.outgoingIterator(member);
                while (k.hasNext()) {
                    Object arc = k.next();
                    Object dst = k.getDestination();
                    if (origin.contains(dst)) continue;
                    Collection destination = (Collection)memberToComponent.get(dst);
                    if (arcFactory == null) {
                        contractedDigraph.putArc(origin, destination, arc);
                        continue;
                    }
                    Collection contractedArc = (Collection)contractedDigraph.getArc(origin, destination);
                    if (contractedArc == null) {
                        contractedArc = arcFactory.createSingleton(arc);
                        contractedDigraph.putArc(origin, destination, contractedArc);
                        continue;
                    }
                    if (contractedArc.size() == 1) {
                        Collection tmp = contractedArc;
                        contractedArc = arcFactory.create();
                        contractedArc.addAll(tmp);
                        contractedDigraph.putArc(origin, destination, contractedArc);
                    }
                    contractedArc.add(arc);
                }
            }
        }
        return contractedDigraph;
    }

    private Object nextDFSRoot() {
        return this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
    }

    private boolean runDirectDFS() {
        this.dfsStack.clear();
        this.reverseDFSFilter.seenVertices.clear();
        Object root = this.nextDFSRoot();
        if (root == null) {
            return false;
        }
        if (this.directDfs == null) {
            this.directDfs = new DepthFirstStampSearch(this.filteredDigraph, root);
        } else {
            this.directDfs.reset(root);
        }
        while (this.directDfs.hasNext()) {
            Object vertex = this.directDfs.next();
            int stamp = this.directDfs.getStamp();
            if (stamp != 2 && stamp != 3) continue;
            this.dfsStack.push(vertex);
            this.reverseDFSFilter.seenVertices.add(vertex);
        }
        this.seen.addAll(this.dfsStack);
        return true;
    }

    private Collection buildStronglyConnectedComponent() {
        Object root = this.dfsStack.pop();
        Collection component = this.componentFactory.createSingleton(root);
        boolean singleton = true;
        if (this.reverseDfs == null) {
            this.reverseDfs = new DepthFirstSearch(this.reverseDigraph, root);
        } else {
            this.reverseDfs.reset(root);
        }
        while (this.reverseDfs.hasNext()) {
            Object vertex = this.reverseDfs.next();
            if (vertex == root) continue;
            if (singleton) {
                Collection tmp = component;
                component = this.componentFactory.create();
                component.addAll(tmp);
                singleton = false;
            }
            component.add(vertex);
            this.dfsStack.remove(vertex);
        }
        this.reverseDFSFilter.seenVertices.removeAll(component);
        return component;
    }

    private class NotSeenPredicate
    implements Predicate {
        private NotSeenPredicate() {
        }

        public boolean evaluate(Object vertex) {
            return !StrongConnection.this.seen.contains(vertex);
        }
    }

    private class DFSSeenVerticesPredicate
    implements Predicate {
        private Set seenVertices = new HashSet();

        private DFSSeenVerticesPredicate() {
        }

        public boolean evaluate(Object vertex) {
            return this.seenVertices.contains(vertex);
        }
    }
}

