/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerDbAdapter;
import org.apache.cayenne.project.ProjectDataSource;

public abstract class DBWizardAction
extends CayenneAction {
    public DBWizardAction(String name, Application application) {
        super(name, application);
    }

    protected DataNode getPreferredNode() {
        DataMap map;
        ProjectController projectController = this.getProjectController();
        DataNode node = projectController.getCurrentDataNode();
        if (node == null && (map = projectController.getCurrentDataMap()) != null) {
            node = projectController.getCurrentDataDomain().lookupDataNode(map);
        }
        return node;
    }

    protected String preferredDataSourceLabel(DBConnectionInfo nodeInfo) {
        if (nodeInfo == null || nodeInfo.getDomainPreference() == null) {
            DataNode node = this.getPreferredNode();
            return node != null && DriverDataSourceFactory.class.getName().equals(node.getDataSourceFactory()) ? "DataNode Connection Info" : null;
        }
        return nodeInfo.getKey();
    }

    protected DBConnectionInfo preferredDataSource() {
        DBConnectionInfo info;
        String key;
        DataNode node = this.getPreferredNode();
        if (node == null) {
            return null;
        }
        DataNodeDefaults nodeDefaults = (DataNodeDefaults)this.getProjectController().getPreferenceDomainForDataDomain().getDetail(node.getName(), DataNodeDefaults.class, false);
        String string = key = nodeDefaults != null ? nodeDefaults.getLocalDataSource() : null;
        if (key != null && (info = (DBConnectionInfo)this.getApplication().getPreferenceDomain().getDetail(key, DBConnectionInfo.class, false)) != null) {
            return info;
        }
        if (!DriverDataSourceFactory.class.getName().equals(node.getDataSourceFactory())) {
            return null;
        }
        DBConnectionInfo nodeInfo = new DBConnectionInfo();
        nodeInfo.copyFrom(((ProjectDataSource)node.getDataSource()).getDataSourceInfo());
        nodeInfo.setDbAdapter(null);
        if (node.getAdapter() instanceof ModelerDbAdapter) {
            nodeInfo.setDbAdapter(((ModelerDbAdapter)node.getAdapter()).getAdapterClassName());
        }
        return nodeInfo;
    }
}

