/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.junit.Assert;
import org.junit.Test;

public class Jira541TestCase {
    private static final String FIELD_NAME = "field";
    private static final String FIELD_VALUE = "name";

    @Test
    public void testFluentBeanIntrospectorOnOverriddenSetter() throws Exception {
        this.testImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFluentBeanIntrospectorOnOverriddenSetterConcurrent() throws Exception {
        ExecutorService executionService = Executors.newFixedThreadPool(256);
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (int i = 0; i < 10000; ++i) {
                futures.add(executionService.submit(() -> {
                    this.testImpl();
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executionService.shutdown();
        }
    }

    private void testImpl() throws Exception {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        propertyUtilsBean.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        SubTypeA subTypeA = new SubTypeA();
        propertyUtilsBean.setProperty((Object)subTypeA, FIELD_NAME, (Object)FIELD_VALUE);
        SubTypeB subTypeB = new SubTypeB();
        propertyUtilsBean.setProperty((Object)subTypeB, FIELD_NAME, (Object)FIELD_VALUE);
        Assert.assertEquals((Object)FIELD_VALUE, (Object)subTypeA.getField());
        Assert.assertEquals((Object)FIELD_VALUE, (Object)subTypeB.getField());
    }

    public static class SubTypeA
    extends BaseType {
        @Override
        public SubTypeA setField(String field) {
            super.setField(field);
            return this;
        }
    }

    public static class SubTypeB
    extends BaseType {
    }

    public static class BaseType {
        private String field;

        public String getField() {
            return this.field;
        }

        public BaseType setField(String objectName) {
            this.field = objectName;
            return this;
        }
    }
}

