/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.web;

import java.applet.Applet;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.TestAbstractConfiguration;
import org.apache.commons.configuration.web.AppletConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAppletConfiguration
extends TestAbstractConfiguration {
    boolean supportsApplet;

    @Before
    public void setUp() throws Exception {
        try {
            new Applet();
            this.supportsApplet = true;
        }
        catch (Exception ex) {
            this.supportsApplet = false;
        }
    }

    protected AbstractConfiguration getConfiguration() {
        final Properties parameters = new Properties();
        parameters.setProperty("key1", "value1");
        parameters.setProperty("key2", "value2");
        parameters.setProperty("list", "value1, value2");
        parameters.setProperty("listesc", "value1\\,value2");
        if (this.supportsApplet) {
            Applet applet = new Applet(){
                private static final long serialVersionUID = 1L;

                public String getParameter(String key) {
                    return parameters.getProperty(key);
                }

                public String[][] getParameterInfo() {
                    return new String[][]{{"key1", "String", ""}, {"key2", "String", ""}, {"list", "String[]", ""}, {"listesc", "String", ""}};
                }
            };
            return new AppletConfiguration(applet);
        }
        return new MapConfiguration(parameters);
    }

    protected AbstractConfiguration getEmptyConfiguration() {
        if (this.supportsApplet) {
            return new AppletConfiguration(new Applet());
        }
        return new BaseConfiguration();
    }

    @Test
    public void testAddPropertyDirect() {
        if (this.supportsApplet) {
            try {
                super.testAddPropertyDirect();
                Assert.fail((String)"addPropertyDirect should throw an UnsupportedException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testClearProperty() {
        if (this.supportsApplet) {
            try {
                super.testClearProperty();
                Assert.fail((String)"testClearProperty should throw an UnsupportedException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

