/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.QueryLoader;

public class QueryLoaderTest
extends BaseTestCase {
    private static final String QUERIES = "/org/apache/commons/dbutils/TestQueries.properties";

    public void testLoad() throws IOException {
        QueryLoader loader = QueryLoader.instance();
        Map q = loader.load(QUERIES);
        Map q2 = loader.load(QUERIES);
        QueryLoaderTest.assertSame((Object)q, (Object)q2);
        QueryLoaderTest.assertEquals((String)"SELECT * FROM SomeTable", (String)((String)q.get("test.query")));
        loader.unload(QUERIES);
        Map q3 = loader.load(QUERIES);
        QueryLoaderTest.assertTrue((q != q3 ? 1 : 0) != 0);
    }

    public void testLoadThrowsIllegalArgumentException() throws IOException {
        QueryLoader queryLoader = QueryLoader.instance();
        try {
            queryLoader.load("e");
            QueryLoaderTest.fail((String)"Expecting exception: IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            QueryLoaderTest.assertEquals((String)"e not found.", (String)e.getMessage());
            QueryLoaderTest.assertEquals((String)QueryLoader.class.getName(), (String)e.getStackTrace()[0].getClassName());
        }
    }
}

