/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

abstract class AbstractPixelParser {
    final BmpHeaderInfo bhi;
    final byte[] colorTable;
    final byte[] imageData;
    final InputStream is;

    AbstractPixelParser(BmpHeaderInfo bmpHeaderInfo, byte[] colorTable, byte[] imageData) {
        this.bhi = Objects.requireNonNull(bmpHeaderInfo, "bmpHeaderInfo");
        this.colorTable = colorTable;
        this.imageData = Objects.requireNonNull(imageData, "imageData");
        this.is = new ByteArrayInputStream(imageData);
    }

    int getColorTableRgb(int index) {
        int actual = index * 4;
        int blue = 0xFF & this.colorTable[actual + 0];
        int green = 0xFF & this.colorTable[actual + 1];
        int red = 0xFF & this.colorTable[actual + 2];
        int alpha = 255;
        return 0xFF000000 | red << 16 | green << 8 | blue << 0;
    }

    public abstract void processImage(ImageBuilder var1) throws ImagingException, IOException;
}

