/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.AbstractBinaryOutputStream;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAsciiOrByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAsciiOrRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByteOrShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoBytes;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDouble;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDoubles;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloats;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoGpsText;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLongs;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRationals;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSBytes;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSLongs;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSRationals;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSShorts;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShortOrLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShortOrLongOrRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShortOrRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShorts;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoXpString;
import org.apache.commons.imaging.formats.tiff.write.AbstractTiffOutputItem;
import org.apache.commons.imaging.formats.tiff.write.ImageDataOffsets;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSummary;

public final class TiffOutputDirectory
extends AbstractTiffOutputItem
implements Iterable<TiffOutputField> {
    public static final Comparator<TiffOutputDirectory> COMPARATOR = Comparator.comparingInt(TiffOutputDirectory::getType);
    private final int type;
    private final List<TiffOutputField> fields = new ArrayList<TiffOutputField>();
    private final ByteOrder byteOrder;
    private TiffOutputDirectory nextDirectory;
    private JpegImageData jpegImageData;
    private AbstractTiffImageData abstractTiffImageData;

    public TiffOutputDirectory(int type, ByteOrder byteOrder) {
        this.type = type;
        this.byteOrder = byteOrder;
    }

    public void add(TagInfoAscii tagInfo, String ... values) throws ImagingException {
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        if (tagInfo.length > 0 && tagInfo.length != bytes.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " byte(s), not " + values.length);
        }
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.ASCII, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoAsciiOrByte tagInfo, String ... values) throws ImagingException {
        byte[] bytes = tagInfo.encodeValue(AbstractFieldType.ASCII, values, this.byteOrder);
        if (tagInfo.length > 0 && tagInfo.length != bytes.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " byte(s), not " + values.length);
        }
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.ASCII, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoAsciiOrRational tagInfo, RationalNumber ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(AbstractFieldType.RATIONAL, values, this.byteOrder);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.RATIONAL, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoAsciiOrRational tagInfo, String ... values) throws ImagingException {
        byte[] bytes = tagInfo.encodeValue(AbstractFieldType.ASCII, values, this.byteOrder);
        if (tagInfo.length > 0 && tagInfo.length != bytes.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " byte(s), not " + values.length);
        }
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.ASCII, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoByte tagInfo, byte value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.BYTE, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoByteOrShort tagInfo, byte ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.BYTE, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoByteOrShort tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoBytes tagInfo, byte ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.BYTE, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoDouble tagInfo, double value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.DOUBLE, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoDoubles tagInfo, double ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.DOUBLE, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoFloat tagInfo, float value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.FLOAT, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoFloats tagInfo, float ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.FLOAT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoGpsText tagInfo, String value) throws ImagingException {
        byte[] bytes = tagInfo.encodeValue(AbstractFieldType.UNDEFINED, value, this.byteOrder);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, (AbstractFieldType)tagInfo.dataTypes.get(0), bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoLong tagInfo, int value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.LONG, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoLongs tagInfo, int ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.LONG, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoRational tagInfo, RationalNumber value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.RATIONAL, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoRationals tagInfo, RationalNumber ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.RATIONAL, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSByte tagInfo, byte value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SBYTE, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSBytes tagInfo, byte ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SBYTE, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShort tagInfo, short value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrLong tagInfo, int ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.LONG, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrLong tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrLongOrRational tagInfo, int ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.LONG, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrLongOrRational tagInfo, RationalNumber ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.RATIONAL, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrLongOrRational tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrRational tagInfo, RationalNumber ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.RATIONAL, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShortOrRational tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoShorts tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSLong tagInfo, int value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SLONG, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSLongs tagInfo, int ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SLONG, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSRational tagInfo, RationalNumber value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SRATIONAL, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSRationals tagInfo, RationalNumber ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SRATIONAL, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSShort tagInfo, short value) throws ImagingException {
        if (tagInfo.length != 1) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not 1");
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, value);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SSHORT, 1, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoSShorts tagInfo, short ... values) throws ImagingException {
        if (tagInfo.length > 0 && tagInfo.length != values.length) {
            throw new ImagingException("Tag expects " + tagInfo.length + " value(s), not " + values.length);
        }
        byte[] bytes = tagInfo.encodeValue(this.byteOrder, values);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.SSHORT, values.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TagInfoXpString tagInfo, String value) throws ImagingException {
        byte[] bytes = tagInfo.encodeValue(AbstractFieldType.BYTE, value, this.byteOrder);
        TiffOutputField tiffOutputField = new TiffOutputField(tagInfo.tag, tagInfo, AbstractFieldType.BYTE, bytes.length, bytes);
        this.add(tiffOutputField);
    }

    public void add(TiffOutputField field) {
        this.fields.add(field);
    }

    public String description() {
        return TiffDirectory.description(this.getType());
    }

    public TiffOutputField findField(int tag) {
        for (TiffOutputField field : this.fields) {
            if (field.tag != tag) continue;
            return field;
        }
        return null;
    }

    public TiffOutputField findField(TagInfo tagInfo) {
        return this.findField(tagInfo.tag);
    }

    public List<TiffOutputField> getFields() {
        return new ArrayList<TiffOutputField>(this.fields);
    }

    @Override
    public String getItemDescription() {
        TiffDirectoryType dirType = TiffDirectoryType.getExifDirectoryType(this.getType());
        return "Directory: " + dirType.name + " (" + this.getType() + ")";
    }

    @Override
    public int getItemLength() {
        return 12 * this.fields.size() + 2 + 4;
    }

    protected List<AbstractTiffOutputItem> getOutputItems(TiffOutputSummary outputSummary) throws ImagingException {
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        TiffOutputField jpegOffsetField = null;
        if (null != this.jpegImageData) {
            jpegOffsetField = new TiffOutputField(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT, AbstractFieldType.LONG, 1, new byte[4]);
            this.add(jpegOffsetField);
            byte[] lengthValue = AbstractFieldType.LONG.writeData(this.jpegImageData.length, outputSummary.byteOrder);
            TiffOutputField jpegLengthField = new TiffOutputField(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, AbstractFieldType.LONG, 1, lengthValue);
            this.add(jpegLengthField);
        }
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS);
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS);
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_TILE_OFFSETS);
        this.removeFieldIfPresent(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS);
        ImageDataOffsets imageDataInfo = null;
        if (null != this.abstractTiffImageData) {
            TagInfoShortOrLong byteCountsTag;
            Object offsetTag;
            boolean stripsNotTiles = this.abstractTiffImageData.stripsNotTiles();
            if (stripsNotTiles) {
                offsetTag = TiffTagConstants.TIFF_TAG_STRIP_OFFSETS;
                byteCountsTag = TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS;
            } else {
                offsetTag = TiffTagConstants.TIFF_TAG_TILE_OFFSETS;
                byteCountsTag = TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS;
            }
            AbstractTiffElement.DataElement[] imageData = this.abstractTiffImageData.getImageData();
            int[] imageDataOffsets = Allocator.intArray(imageData.length);
            int[] imageDataByteCounts = Allocator.intArray(imageData.length);
            Arrays.setAll(imageDataByteCounts, i -> imageData[i].length);
            TiffOutputField imageDataOffsetField = new TiffOutputField((TagInfo)offsetTag, AbstractFieldType.LONG, imageDataOffsets.length, AbstractFieldType.LONG.writeData(imageDataOffsets, outputSummary.byteOrder));
            this.add(imageDataOffsetField);
            byte[] data = AbstractFieldType.LONG.writeData(imageDataByteCounts, outputSummary.byteOrder);
            TiffOutputField byteCountsField = new TiffOutputField(byteCountsTag, AbstractFieldType.LONG, imageDataByteCounts.length, data);
            this.add(byteCountsField);
            imageDataInfo = new ImageDataOffsets(imageData, imageDataOffsets, imageDataOffsetField);
        }
        ArrayList<AbstractTiffOutputItem> result = new ArrayList<AbstractTiffOutputItem>();
        result.add(this);
        this.sortFields();
        for (TiffOutputField field : this.fields) {
            if (field.isLocalValue()) continue;
            AbstractTiffOutputItem item = field.getSeperateValue();
            result.add(item);
        }
        if (null != imageDataInfo) {
            Collections.addAll(result, imageDataInfo.outputItems);
            outputSummary.addTiffImageData(imageDataInfo);
        }
        if (null != this.jpegImageData) {
            AbstractTiffOutputItem.Value item = new AbstractTiffOutputItem.Value("JPEG image data", this.jpegImageData.getData());
            result.add(item);
            outputSummary.add(item, jpegOffsetField);
        }
        return result;
    }

    public JpegImageData getRawJpegImageData() {
        return this.jpegImageData;
    }

    public AbstractTiffImageData getRawTiffImageData() {
        return this.abstractTiffImageData;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public Iterator<TiffOutputField> iterator() {
        return this.fields.iterator();
    }

    public void removeField(int tag) {
        ArrayList<TiffOutputField> matches = new ArrayList<TiffOutputField>();
        for (TiffOutputField field : this.fields) {
            if (field.tag != tag) continue;
            matches.add(field);
        }
        this.fields.removeAll(matches);
    }

    public void removeField(TagInfo tagInfo) {
        this.removeField(tagInfo.tag);
    }

    private void removeFieldIfPresent(TagInfo tagInfo) {
        TiffOutputField field = this.findField(tagInfo);
        if (null != field) {
            this.fields.remove(field);
        }
    }

    public void setJpegImageData(JpegImageData rawJpegImageData) {
        this.jpegImageData = rawJpegImageData;
    }

    public void setNextDirectory(TiffOutputDirectory nextDirectory) {
        this.nextDirectory = nextDirectory;
    }

    public void setTiffImageData(AbstractTiffImageData rawTiffImageData) {
        this.abstractTiffImageData = rawTiffImageData;
    }

    public void sortFields() {
        Comparator comparator = (e1, e2) -> {
            if (e1.tag != e2.tag) {
                return e1.tag - e2.tag;
            }
            return e1.getSortHint() - e2.getSortHint();
        };
        this.fields.sort(comparator);
    }

    @Override
    public void writeItem(AbstractBinaryOutputStream bos) throws IOException, ImagingException {
        bos.write2Bytes(this.fields.size());
        for (TiffOutputField field : this.fields) {
            field.writeField(bos);
        }
        long nextDirectoryOffset = 0L;
        if (this.nextDirectory != null) {
            nextDirectoryOffset = this.nextDirectory.getOffset();
        }
        if (nextDirectoryOffset == -1L) {
            bos.write4Bytes(0);
        } else {
            bos.write4Bytes((int)nextDirectoryOffset);
        }
    }
}

